/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

import java.util.EnumSet;
import java.util.HashMap;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.SimpleDissector;
import nl.basjes.parse.core.Value;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.test.DissectorTester;
import org.junit.Test;

public class ParserDuplicateOutputTest {
    @Test
    public void testParseString() {
        DissectorTester.create().verbose().withDissector((Dissector)new FooDissector()).withDissector((Dissector)new BarDissector()).withInput("SomeThing").printPossible().expect("STRING:output", "foo").expect("STRING:output", "bar").checkExpectations();
    }

    public static class BarDissector
    extends TestDissector {
        public void dissect(Parsable<?> parsable, String inputname, Value value) throws DissectionFailure {
            parsable.addDissection(inputname, "STRING", "output", "bar");
        }
    }

    public static class FooDissector
    extends TestDissector {
        public void dissect(Parsable<?> parsable, String inputname, Value value) throws DissectionFailure {
            parsable.addDissection(inputname, "STRING", "output", "foo");
        }
    }

    public static abstract class TestDissector
    extends SimpleDissector {
        private static HashMap<String, EnumSet<Casts>> dissectorConfig = new HashMap();

        public TestDissector() {
            super("INPUT", dissectorConfig);
        }

        static {
            dissectorConfig.put("STRING:output", Casts.STRING_ONLY);
        }
    }
}

