/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import nl.basjes.parse.core.test.TestRecord;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DissectorTester
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DissectorTester.class);
    private boolean verbose = false;
    private final List<String> inputValues = new ArrayList<String>();
    private final Map<String, String> expectedStrings = new TreeMap<String, String>();
    private final Map<String, Long> expectedLongs = new TreeMap<String, Long>();
    private final Map<String, Double> expectedDoubles = new TreeMap<String, Double>();
    private final List<String> expectedValuePresent = new ArrayList<String>();
    private final List<String> expectedAbsentStrings = new ArrayList<String>();
    private final List<String> expectedAbsentLongs = new ArrayList<String>();
    private final List<String> expectedAbsentDoubles = new ArrayList<String>();
    private final List<String> expectedPossible = new ArrayList<String>();
    private Parser<TestRecord> parser = new Parser(TestRecord.class);
    private String pathPrefix = "";
    private static final Pattern PREFIX_INSERTER = Pattern.compile("([^:]+:)([^:]+)");

    private DissectorTester() {
    }

    public static DissectorTester create() {
        return new DissectorTester();
    }

    public DissectorTester withParser(Parser<TestRecord> newParser) {
        this.parser = newParser;
        return this;
    }

    public DissectorTester withDissector(String fieldName, Dissector dissector) {
        return this.withDissector(new DummyDissector(dissector.getInputType(), fieldName)).withDissector(dissector);
    }

    public DissectorTester withDissector(Dissector dissector) {
        this.parser.addDissector(dissector);
        if (this.parser.getAllDissectors().size() == 1) {
            this.parser.setRootType(dissector.getInputType());
        }
        return this;
    }

    public DissectorTester withInput(String inputValue) {
        this.inputValues.add(inputValue);
        return this;
    }

    private void addStringSetter(String fieldname) {
        try {
            this.parser.addParseTarget(TestRecord.class.getMethod("setStringValue", String.class, String.class), fieldname);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void addLongSetter(String fieldname) {
        try {
            this.parser.addParseTarget(TestRecord.class.getMethod("setLongValue", String.class, Long.class), fieldname);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void addDoubleSetter(String fieldname) {
        try {
            this.parser.addParseTarget(TestRecord.class.getMethod("setDoubleValue", String.class, Double.class), fieldname);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public DissectorTester expect(String fieldname, String expected) {
        fieldname = this.addPrefix(fieldname);
        this.expectedStrings.put(fieldname, expected);
        this.addStringSetter(fieldname);
        return this;
    }

    public DissectorTester expect(String fieldname, Long expected) {
        fieldname = this.addPrefix(fieldname);
        this.expectedLongs.put(fieldname, expected);
        this.addLongSetter(fieldname);
        return this;
    }

    public DissectorTester expect(String fieldname, Integer expected) {
        return this.expect(fieldname, (long)expected);
    }

    public DissectorTester expect(String fieldname, Double expected) {
        fieldname = this.addPrefix(fieldname);
        this.expectedDoubles.put(fieldname, expected);
        this.addDoubleSetter(fieldname);
        return this;
    }

    public DissectorTester expect(String fieldname, Float expected) {
        return this.expect(fieldname, Double.valueOf(expected.floatValue()));
    }

    public DissectorTester expectNull(String fieldname) {
        fieldname = this.addPrefix(fieldname);
        this.expectedStrings.put(fieldname, null);
        this.addStringSetter(fieldname);
        return this;
    }

    public DissectorTester expectValuePresent(String fieldname) {
        fieldname = this.addPrefix(fieldname);
        this.expectedValuePresent.add(fieldname);
        try {
            this.parser.addParseTarget(TestRecord.class.getMethod("setStringValue", String.class, String.class), fieldname);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return this;
    }

    public DissectorTester expectAbsentString(String fieldname) {
        fieldname = this.addPrefix(fieldname);
        this.expectedAbsentStrings.add(fieldname);
        this.addStringSetter(fieldname);
        return this;
    }

    public DissectorTester expectAbsentLong(String fieldname) {
        fieldname = this.addPrefix(fieldname);
        this.expectedAbsentLongs.add(fieldname);
        this.addLongSetter(fieldname);
        return this;
    }

    public DissectorTester expectAbsentDouble(String fieldname) {
        fieldname = this.addPrefix(fieldname);
        this.expectedAbsentDoubles.add(fieldname);
        this.addDoubleSetter(fieldname);
        return this;
    }

    public DissectorTester expectPossible(String fieldname) {
        fieldname = this.addPrefix(fieldname);
        this.expectedPossible.add(fieldname);
        return this;
    }

    public DissectorTester verbose() {
        this.verbose = true;
        return this;
    }

    public DissectorTester withPathPrefix(String prefix) {
        this.pathPrefix = prefix == null || prefix.isEmpty() ? "" : "$1" + prefix + "$2";
        return this;
    }

    String addPrefix(String field) {
        if (this.pathPrefix.isEmpty()) {
            return field;
        }
        return PREFIX_INSERTER.matcher(field).replaceAll(this.pathPrefix);
    }

    private void expectEquals(List<ExpectationResult> expectationResults, String fieldName, String msg, Object left, Object right) {
        boolean expression = false;
        String expected = "<<<null>>>";
        if (left == null) {
            if (right == null) {
                expression = true;
            }
        } else {
            expected = left.toString();
            expression = left.equals(right);
        }
        if (expression) {
            expectationResults.add(new ExpectationResult(msg, fieldName, expected, null));
        } else if (right == null) {
            expectationResults.add(new ExpectationResult(msg, fieldName, expected, "Wrong value: <<<null>>>"));
        } else {
            expectationResults.add(new ExpectationResult(msg, fieldName, expected, "Wrong value: " + right));
        }
    }

    public DissectorTester checkExpectations() {
        DissectorTester tester = (DissectorTester)SerializationUtils.clone((Serializable)this);
        try {
            return tester.checkExpectationsDirect();
        }
        catch (AssertionError ae) {
            throw new AssertionError((Object)((Throwable)((Object)ae)).getMessage());
        }
    }

    private DissectorTester checkExpectationsDirect() {
        if (this.expectedStrings.isEmpty() && this.expectedLongs.isEmpty() && this.expectedDoubles.isEmpty() && this.expectedValuePresent.isEmpty() && this.expectedAbsentStrings.isEmpty() && this.expectedAbsentLongs.isEmpty() && this.expectedAbsentDoubles.isEmpty() && this.expectedPossible.isEmpty()) {
            Assert.fail((String)"No expected values were specified");
        }
        ArrayList<ExpectationResult> results = new ArrayList<ExpectationResult>(32);
        results.addAll(this.checkDissectors());
        results.addAll(this.checkExpectedValues());
        results.addAll(this.checkExpectedAbsent());
        results.addAll(this.checkExpectedPossible());
        this.summarizeResults(results);
        return this;
    }

    private void summarizeResults(List<ExpectationResult> results) {
        boolean success = true;
        String headerField = "Field";
        String headerCheck = "Check";
        String headerExpectedValue = "Expected Value";
        String headerFailReason = "Fail reason";
        int maxExpectation = "Field".length();
        int maxFieldName = "Check".length();
        int maxExpectedValue = "Expected Value".length();
        int maxFailReason = "Fail reason".length();
        String nullString = " ";
        for (ExpectationResult expectationResult : results) {
            maxExpectation = Math.max(maxExpectation, expectationResult.expectation.length());
            maxFieldName = Math.max(maxFieldName, expectationResult.field.length());
            maxExpectedValue = expectationResult.value == null ? Math.max(maxExpectedValue, nullString.length()) : Math.max(maxExpectedValue, expectationResult.value.length());
            if (expectationResult.failReason == null) {
                maxFailReason = Math.max(maxFailReason, nullString.length());
                continue;
            }
            success = false;
            maxFailReason = Math.max(maxFailReason, expectationResult.failReason.length());
        }
        if (!success) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("\n[     ] /").append(this.padding("", maxExpectation + maxFieldName + maxExpectedValue + maxFailReason + 11, '=')).append("\\\n");
            sb.append("[     ] | ").append("Field").append(this.padding("Field", maxFieldName)).append(" | ").append("Check").append(this.padding("Check", maxExpectation)).append(" | ").append("Expected Value").append(this.padding("Expected Value", maxExpectedValue)).append(" | ").append("Fail reason").append(this.padding("Fail reason", maxFailReason)).append(" |").append("\n[     ] +").append(this.padding("", maxFieldName + 2, '-')).append('+').append(this.padding("", maxExpectation + 2, '-')).append('+').append(this.padding("", maxExpectedValue + 2, '-')).append('+').append(this.padding("", maxFailReason + 2, '-')).append('+').append("\n");
            for (ExpectationResult expectationResult : results) {
                if (expectationResult.failReason == null) {
                    sb.append("[     ] ");
                } else {
                    sb.append("[ERROR] ");
                }
                sb.append("| ").append(expectationResult.field).append(this.padding(expectationResult.field, maxFieldName)).append(" | ").append(expectationResult.expectation).append(this.padding(expectationResult.expectation, maxExpectation)).append(" | ");
                String value = expectationResult.value;
                if (expectationResult.value == null) {
                    value = nullString;
                }
                sb.append(this.padding(value, maxExpectedValue)).append(value).append(" | ");
                if (expectationResult.failReason == null) {
                    sb.append(this.padding("", maxFailReason));
                } else {
                    sb.append(expectationResult.failReason).append(this.padding(expectationResult.failReason, maxFailReason));
                }
                sb.append(" |\n");
            }
            sb.append("[     ] \\").append(this.padding("", maxExpectation + maxFieldName + maxExpectedValue + maxFailReason + 11, '=')).append("/\n");
            Assert.fail((String)sb.toString());
        }
    }

    private List<ExpectationResult> checkExpectedValues() {
        if (this.expectedStrings.size() + this.expectedLongs.size() + this.expectedDoubles.size() + this.expectedValuePresent.size() == 0) {
            return Collections.emptyList();
        }
        if (this.inputValues.isEmpty()) {
            Assert.fail((String)"No inputvalues were specified");
        }
        ArrayList<ExpectationResult> expectationResults = new ArrayList<ExpectationResult>(32);
        for (String inputValue : this.inputValues) {
            String fieldName;
            if (this.verbose) {
                LOG.info("Checking for input: {}", (Object)inputValue);
            }
            TestRecord result = this.parse(inputValue);
            if (this.verbose) {
                LOG.info("Parse completed successfully");
            }
            int longestFieldName = 0;
            HashSet<String> allFieldNames = new HashSet<String>();
            allFieldNames.addAll(this.expectedStrings.keySet());
            allFieldNames.addAll(this.expectedLongs.keySet());
            allFieldNames.addAll(this.expectedDoubles.keySet());
            allFieldNames.addAll(this.expectedValuePresent);
            for (String string : allFieldNames) {
                longestFieldName = Math.max(longestFieldName, string.length());
            }
            for (Map.Entry entry : this.expectedStrings.entrySet()) {
                fieldName = (String)entry.getKey();
                if (!result.hasStringValue(fieldName)) {
                    expectationResults.add(new ExpectationResult("String value", fieldName, entry.getValue(), "Missing"));
                } else {
                    this.expectEquals(expectationResults, fieldName, "String value", entry.getValue(), result.getStringValue(fieldName));
                }
                if (!this.verbose) continue;
                LOG.info("Passed: String value for '{}'{} was correctly : {}", new Object[]{fieldName, this.padding(fieldName, longestFieldName), result.getStringValue(fieldName)});
            }
            for (Map.Entry entry : this.expectedLongs.entrySet()) {
                fieldName = (String)entry.getKey();
                if (!result.hasLongValue(fieldName)) {
                    expectationResults.add(new ExpectationResult("Long value", fieldName, entry.getValue(), "Missing"));
                } else {
                    this.expectEquals(expectationResults, fieldName, "Long value", entry.getValue(), result.getLongValue(fieldName));
                }
                if (!this.verbose) continue;
                LOG.info("Passed: Long   value for '{}'{} was correctly : {}", new Object[]{fieldName, this.padding(fieldName, longestFieldName), result.getLongValue(fieldName)});
            }
            for (Map.Entry entry : this.expectedDoubles.entrySet()) {
                fieldName = (String)entry.getKey();
                if (!result.hasDoubleValue(fieldName)) {
                    expectationResults.add(new ExpectationResult("Double value", fieldName, entry.getValue(), "Missing"));
                } else {
                    this.expectEquals(expectationResults, fieldName, "Double value", entry.getValue(), result.getDoubleValue(fieldName));
                }
                if (!this.verbose) continue;
                LOG.info("Passed: Double value for '{}'{} was correctly : {}", new Object[]{fieldName, this.padding(fieldName, longestFieldName), result.getDoubleValue(fieldName)});
            }
            Iterator<Object> iterator = this.expectedValuePresent.iterator();
            while (iterator.hasNext()) {
                String string;
                expectationResults.add(new ExpectationResult("String present", string, null, result.hasStringValue(string = (String)iterator.next()) ? null : "Missing"));
                if (!this.verbose) continue;
                LOG.info("Passed: A value for '{}'{} was present.", (Object)string, (Object)this.padding(string, longestFieldName));
            }
        }
        return expectationResults;
    }

    private List<ExpectationResult> checkExpectedAbsent() {
        if (this.expectedAbsentStrings.size() + this.expectedAbsentLongs.size() + this.expectedAbsentDoubles.size() == 0) {
            return Collections.emptyList();
        }
        if (this.inputValues.isEmpty()) {
            Assert.fail((String)"No inputvalues were specified");
        }
        ArrayList<ExpectationResult> expectationResults = new ArrayList<ExpectationResult>(32);
        for (String inputValue : this.inputValues) {
            if (this.verbose) {
                LOG.info("Checking for input: {}", (Object)inputValue);
            }
            TestRecord result = this.parse(inputValue);
            if (this.verbose) {
                LOG.info("Parse completed successfully");
            }
            int longestFieldName = 0;
            HashSet<String> allFieldNames = new HashSet<String>();
            allFieldNames.addAll(this.expectedAbsentStrings);
            allFieldNames.addAll(this.expectedAbsentLongs);
            allFieldNames.addAll(this.expectedAbsentDoubles);
            allFieldNames.addAll(this.expectedValuePresent);
            for (String key : allFieldNames) {
                longestFieldName = Math.max(longestFieldName, key.length());
            }
            for (String fieldName : this.expectedAbsentStrings) {
                expectationResults.add(new ExpectationResult("String absent", fieldName, result.getStringValue(fieldName), result.hasStringValue(fieldName) ? "Present" : null));
                if (!this.verbose) continue;
                LOG.info("Passed: String value for '{}'{} was correctly absent", (Object)fieldName, (Object)this.padding(fieldName, longestFieldName));
            }
            for (String fieldName : this.expectedAbsentLongs) {
                expectationResults.add(new ExpectationResult("Long absent", fieldName, result.getLongValue(fieldName), result.hasLongValue(fieldName) ? "Present" : null));
                if (!this.verbose) continue;
                LOG.info("Passed: Long value for '{}'{} was correctly absent", (Object)fieldName, (Object)this.padding(fieldName, longestFieldName));
            }
            for (String fieldName : this.expectedAbsentDoubles) {
                expectationResults.add(new ExpectationResult("Double absent", fieldName, result.getDoubleValue(fieldName), result.hasDoubleValue(fieldName) ? "Present" : null));
                if (!this.verbose) continue;
                LOG.info("Passed: Double value for '{}'{} was correctly absent", (Object)fieldName, (Object)this.padding(fieldName, longestFieldName));
            }
        }
        return expectationResults;
    }

    private TestRecord parse(String inputValue) {
        TestRecord testRecord = new TestRecord();
        if (this.verbose) {
            testRecord.setVerbose();
        }
        try {
            return (TestRecord)this.parser.parse((Object)testRecord, inputValue);
        }
        catch (DissectionFailure | InvalidDissectorException | MissingDissectorsException e) {
            Assert.fail((String)e.toString());
            return testRecord;
        }
    }

    private List<ExpectationResult> checkExpectedPossible() {
        if (this.expectedPossible.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExpectationResult> expectationResults = new ArrayList<ExpectationResult>(32);
        int longestFieldName = 0;
        for (String fieldName : this.expectedPossible) {
            longestFieldName = Math.max(longestFieldName, fieldName.length());
        }
        List allpossible = this.parser.getPossiblePaths();
        for (String fieldName : this.expectedPossible) {
            expectationResults.add(new ExpectationResult("Fieldname possible", fieldName, null, allpossible.contains(fieldName) ? null : "Not possible"));
            if (!this.verbose) continue;
            LOG.info("Passed: Fieldname '{}'{} is possible.", (Object)fieldName, (Object)this.padding(fieldName, longestFieldName));
        }
        return expectationResults;
    }

    private List<ExpectationResult> checkDissectors() {
        ArrayList<ExpectationResult> results = new ArrayList<ExpectationResult>();
        Set dissectors = this.parser.getAllDissectors();
        for (Dissector dissector : dissectors) {
            for (String output : dissector.getPossibleOutput()) {
                String[] splitOutput = output.split(":", 2);
                if (!splitOutput[0].toUpperCase(Locale.ENGLISH).equals(splitOutput[0])) {
                    results.add(new ExpectationResult("Dissector input type is UPPERcase", dissector.getClass().getSimpleName() + " --> " + output, splitOutput[0].toUpperCase(Locale.ENGLISH), "\"" + splitOutput[0] + "\" is not fully uppercase."));
                }
                if (!splitOutput[1].toLowerCase(Locale.ENGLISH).equals(splitOutput[1])) {
                    results.add(new ExpectationResult("Dissector output name is lowercase", dissector.getClass().getSimpleName() + " --> " + output, splitOutput[1].toLowerCase(Locale.ENGLISH), "\"" + splitOutput[1] + "\" is not fully uppercase."));
                }
                Assert.assertNotNull((String)"Dissector::prepareForDissect may NEVER return null!!", (Object)dissector.prepareForDissect("This will", "never exist"));
            }
        }
        return results;
    }

    private String padding(String name, int longestFieldName) {
        return this.padding(name, longestFieldName, ' ');
    }

    private String padding(String name, int longestFieldName, char pad) {
        int length = longestFieldName - name.length();
        if (length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(pad);
        }
        return sb.toString();
    }

    public DissectorTester printDissectors() {
        LOG.info("=====================================================");
        LOG.info("Dissectors:");
        LOG.info("=====================================================");
        Set dissectors = this.parser.getAllDissectors();
        for (Dissector dissector : dissectors) {
            LOG.info("-----------------------------------------------------");
            LOG.info("{} --> {}", (Object)dissector.getInputType(), (Object)dissector.getClass().getSimpleName());
            for (String output : dissector.getPossibleOutput()) {
                LOG.info(">> {}", (Object)output);
            }
        }
        LOG.info("=====================================================");
        return this;
    }

    public DissectorTester printPossible() {
        LOG.info("=====================================================");
        LOG.info("Possible:");
        LOG.info("----------");
        for (String path : this.parser.getPossiblePaths()) {
            LOG.info("---> {}", (Object)path);
        }
        LOG.info("=====================================================");
        return this;
    }

    public List<String> getPossible() {
        return this.parser.getPossiblePaths();
    }

    public DissectorTester printAllPossibleValues() {
        if (this.inputValues.isEmpty()) {
            Assert.fail((String)"No inputvalues were specified");
        }
        try {
            List possibleFieldNames = this.parser.getPossiblePaths();
            for (String path : possibleFieldNames) {
                this.parser.addParseTarget(TestRecord.class.getMethod("setStringValue", String.class, String.class), path);
            }
            for (String inputValue : this.inputValues) {
                LOG.info("=====================================================");
                LOG.info("All values (except wildcards) for input:{}", (Object)inputValue);
                LOG.info("=====================================================");
                for (String path : possibleFieldNames) {
                    this.parser.addParseTarget(TestRecord.class.getMethod("setStringValue", String.class, String.class), path);
                }
                TestRecord result = (TestRecord)this.parser.parse(inputValue);
                int longestFieldName = 0;
                for (String fieldName : possibleFieldNames) {
                    longestFieldName = Math.max(longestFieldName, fieldName.length());
                }
                for (String fieldName : possibleFieldNames) {
                    String value = result.getStringValue(fieldName);
                    if (value == null) {
                        value = "<<<null>>>";
                    }
                    LOG.info("Found value for {}{} = {}", new Object[]{fieldName, this.padding(fieldName, longestFieldName), value});
                }
            }
            LOG.info("=====================================================");
        }
        catch (NoSuchMethodException | DissectionFailure | InvalidDissectorException | MissingDissectorsException e) {
            e.printStackTrace();
            Assert.fail((String)"Shouldn't have any exceptions");
        }
        return this;
    }

    public DissectorTester printSeparator() {
        LOG.info("");
        LOG.info("--------------------------------------------------------------------------------");
        LOG.info("");
        return this;
    }

    public static class DummyDissector
    extends Dissector {
        private String outputType;
        private String fieldName;

        public DummyDissector() {
        }

        public DummyDissector(String newOutputType, String newFieldName) {
            this.fieldName = newFieldName;
            this.outputType = newOutputType;
        }

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            ParsedField field = parsable.getParsableField("DUMMYROOT", inputname);
            parsable.addDissection(inputname, this.outputType, this.fieldName, field.getValue());
        }

        public String getInputType() {
            return "DUMMYROOT";
        }

        public List<String> getPossibleOutput() {
            return Collections.singletonList(this.outputType + ":" + this.fieldName);
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }

        protected void initializeNewInstance(Dissector newInstance) {
            DummyDissector dummyDissector = (DummyDissector)newInstance;
            dummyDissector.fieldName = this.fieldName;
            dummyDissector.outputType = this.outputType;
        }
    }

    private static class ExpectationResult {
        String expectation;
        String field;
        String value;
        String failReason;

        ExpectationResult(String expectation, String field, Object value, String failReason) {
            this.expectation = expectation;
            this.field = field;
            this.value = value == null ? null : value.toString();
            this.failReason = failReason;
        }
    }
}

