/*
 * Apache HTTPD & NGINX Access log parsing made easy
 * Copyright (C) 2011-2021 Niels Basjes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.basjes.parse.core;

import java.util.EnumSet;

public enum Casts {
    STRING, LONG, DOUBLE;
    public static final EnumSet<Casts> NO_CASTS         = EnumSet.noneOf(Casts.class);
    public static final EnumSet<Casts> STRING_ONLY      = EnumSet.of(STRING);
    public static final EnumSet<Casts> LONG_ONLY        = EnumSet.of(LONG);
    public static final EnumSet<Casts> DOUBLE_ONLY      = EnumSet.of(DOUBLE);
    public static final EnumSet<Casts> STRING_OR_LONG   = EnumSet.of(STRING, LONG);
    public static final EnumSet<Casts> STRING_OR_DOUBLE = EnumSet.of(STRING, DOUBLE);
    public static final EnumSet<Casts> STRING_OR_LONG_OR_DOUBLE = EnumSet.of(STRING, LONG, DOUBLE);
}
