/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.sunspec.device;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\t\u00a8\u0006\u0010"}, d2={"Lnl/basjes/sunspec/device/Utils;", "", "<init>", "()V", "addSunSHeaderBlock", "Lnl/basjes/modbus/schema/Field;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "sunSpecStartAddress", "Lnl/basjes/modbus/device/api/Address;", "addSunSpecEndOfChainBlock", "Lnl/basjes/modbus/schema/Block;", "addModelHeaderFields", "Lkotlin/Pair;", "block", "thisModelAddress", "sunspec-device"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @NotNull
    public final Field addSunSHeaderBlock(@Nullable SchemaDevice schemaDevice, @NotNull Address sunSpecStartAddress) {
        Intrinsics.checkNotNullParameter((Object)sunSpecStartAddress, (String)"sunSpecStartAddress");
        Block.BlockBuilder blockBuilder = Block.Companion.builder();
        SchemaDevice schemaDevice2 = schemaDevice;
        Intrinsics.checkNotNull((Object)schemaDevice2);
        Block sunSHeaderBlock = blockBuilder.schemaDevice(schemaDevice2).id("SunSpecHeader").description("The header that starts the SunSpec model list").build();
        return Field.Companion.builder().block(sunSHeaderBlock).id("SunS").description("The SunS header").immutable(true).system(true).expression("utf8(" + sunSpecStartAddress + "#2)").build();
    }

    @NotNull
    public final Block addSunSpecEndOfChainBlock(@Nullable SchemaDevice schemaDevice) {
        Block.BlockBuilder blockBuilder = Block.Companion.builder();
        SchemaDevice schemaDevice2 = schemaDevice;
        Intrinsics.checkNotNull((Object)schemaDevice2);
        return blockBuilder.schemaDevice(schemaDevice2).id("EndOfModelChain").description("The final marker that closes the SunSpec model list").build();
    }

    @NotNull
    public final Pair<Field, Field> addModelHeaderFields(@Nullable Block block, @NotNull Address thisModelAddress) {
        Intrinsics.checkNotNullParameter((Object)thisModelAddress, (String)"thisModelAddress");
        Field.FieldBuilder fieldBuilder = Field.Companion.builder();
        Block block2 = block;
        Intrinsics.checkNotNull((Object)block2);
        Field modelIdField = fieldBuilder.block(block2).id("ID").description("Model identifier").immutable(true).expression("uint16(" + thisModelAddress + ")").system(true).build();
        Field modelLengthField = Field.Companion.builder().block(block).id("L").description("Model length").immutable(true).expression("uint16(" + Address.increment$default((Address)thisModelAddress, (int)0, (int)1, null) + ")").system(true).build();
        return new Pair((Object)modelIdField, (Object)modelLengthField);
    }
}

