/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.sunspec.device;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.utils.CodeGeneration;
import nl.basjes.modbus.schema.utils.StringTable;
import nl.basjes.sunspec.device.SunSpecDeviceModelFinder;
import nl.basjes.sunspec.device.Utils;
import nl.basjes.sunspec.model.SunSpec;
import nl.basjes.sunspec.model.entities.Group;
import nl.basjes.sunspec.model.entities.Point;
import nl.basjes.sunspec.model.entities.SunSpecModel;
import nl.basjes.sunspec.model.entities.Symbol;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\rH\u0007J?\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010\"\u001a\u00020\r*\u00020!H\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010\r*\u00020!H\u0002J(\u0010$\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lnl/basjes/sunspec/device/SunspecDevice;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "getFirstRegisterValue", "Lnl/basjes/modbus/device/api/RegisterValue;", "field", "Lnl/basjes/modbus/schema/Field;", "setCommentOnFirstRegisterValue", "", "comment", "", "generate", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "description", "addGroup", "block", "Lnl/basjes/modbus/schema/Block;", "prefix", "group", "Lnl/basjes/sunspec/model/entities/Group;", "thisModelAddress", "Lnl/basjes/modbus/device/api/Address;", "modelId", "", "modelLength", "(Lnl/basjes/modbus/schema/Block;Ljava/lang/String;Lnl/basjes/sunspec/model/entities/Group;Lnl/basjes/modbus/device/api/Address;ILjava/lang/Integer;)V", "mappingString", "point", "Lnl/basjes/sunspec/model/entities/Point;", "getCamelCaseName", "getCamelCaseSfName", "createAndAddFieldToModel", "modelBaseAddress", "TYPE_MAPPINGS_NO_SYMBOLS", "", "Lnl/basjes/sunspec/model/entities/Point$Type;", "Lnl/basjes/sunspec/device/SunspecDevice$TypeMapping;", "TYPE_MAPPINGS_WITH_SYMBOLS", "TypeMapping", "sunspec-device"})
public final class SunspecDevice {
    @NotNull
    public static final SunspecDevice INSTANCE = new SunspecDevice();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Map<Point.Type, TypeMapping> TYPE_MAPPINGS_NO_SYMBOLS;
    @NotNull
    private static final Map<Point.Type, TypeMapping> TYPE_MAPPINGS_WITH_SYMBOLS;

    private SunspecDevice() {
    }

    private final RegisterValue getFirstRegisterValue(Field field) {
        field.initialize();
        Expression expression = field.getParsedExpression();
        if (expression == null) {
            return null;
        }
        Expression parsedExpression = expression;
        List registerValues = parsedExpression.getRegisterValues(field.getBlock().getSchemaDevice());
        if (registerValues.isEmpty()) {
            return null;
        }
        return (RegisterValue)registerValues.get(0);
    }

    private final void setCommentOnFirstRegisterValue(Field field, String comment) {
        block0: {
            RegisterValue registerValue = this.getFirstRegisterValue(field);
            if (registerValue == null) break block0;
            registerValue.setComment(comment);
        }
    }

    @JvmStatic
    @Nullable
    public static final SchemaDevice generate(@NotNull ModbusDevice modbusDevice, @NotNull String description) throws ModbusException {
        SchemaDevice schemaDevice;
        block14: {
            Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            SunSpec sunSpec = new SunSpec();
            List<SunSpecDeviceModelFinder.DeviceSunSpecModel> deviceSunSpecModels = SunSpecDeviceModelFinder.INSTANCE.findDeviceSunSpecModels(modbusDevice);
            if (deviceSunSpecModels.isEmpty()) {
                LOG.error("Unable to find any SunSpec models");
                return null;
            }
            StringTable table = new StringTable();
            String[] stringArray = new String[]{"Model", "Address", "Length", "Label"};
            table.withHeaders(stringArray);
            for (SunSpecDeviceModelFinder.DeviceSunSpecModel deviceSunSpecModel : deviceSunSpecModels) {
                StringTable stringTable;
                String[] stringArray2;
                SunSpecModel model = sunSpec.getModel(deviceSunSpecModel.getId());
                if (model == null) {
                    stringArray2 = new String[]{String.valueOf(deviceSunSpecModel.getId()), deviceSunSpecModel.getAddress().toCleanFormat(), String.valueOf(deviceSunSpecModel.getRegisters()), "Non existent model"};
                    stringTable = table.addRow(stringArray2);
                    continue;
                }
                stringArray2 = new String[4];
                stringArray2[0] = String.valueOf(deviceSunSpecModel.getId());
                stringArray2[1] = deviceSunSpecModel.getAddress().toCleanFormat();
                stringArray2[2] = String.valueOf(deviceSunSpecModel.getRegisters());
                String string = model.getCleanLabel();
                if (string == null) {
                    string = "";
                }
                stringArray2[3] = string;
                stringTable = table.addRow(stringArray2);
            }
            LOG.info("Detected models: \n{}", (Object)table);
            schemaDevice = new SchemaDevice(description, 0, 2, null);
            SchemaDevice.connect$default((SchemaDevice)schemaDevice, (ModbusDevice)modbusDevice, (int)0, (int)2, null);
            for (SunSpecDeviceModelFinder.DeviceSunSpecModel deviceSunSpecModel : deviceSunSpecModels) {
                Object endChainId;
                int modelId = deviceSunSpecModel.getId();
                int modelLength = deviceSunSpecModel.getRegisters();
                Address modelAddress = deviceSunSpecModel.getAddress();
                if (modelId == 0) {
                    Field sunSHeaderBlock = Utils.INSTANCE.addSunSHeaderBlock(schemaDevice, deviceSunSpecModel.getAddress());
                    INSTANCE.setCommentOnFirstRegisterValue(sunSHeaderBlock, "--------------------------------------\nSunS header");
                    continue;
                }
                if (modelId == 65535) {
                    Block endChainBlock = Utils.INSTANCE.addSunSpecEndOfChainBlock(schemaDevice);
                    endChainId = (Field)Utils.INSTANCE.addModelHeaderFields(endChainBlock, modelAddress).component1();
                    INSTANCE.setCommentOnFirstRegisterValue((Field)endChainId, "--------------------------------------\nNO MORE MODELS");
                    break;
                }
                SunSpecModel sunSpecModel = sunSpec.getModel(modelId);
                if (sunSpecModel == null) {
                    LOG.fatal("Unable to get model for ID: {}", (Object)modelId);
                    continue;
                }
                endChainId = sunSpecModel.getGroup().getDescription();
                String modelDescription = endChainId == null || StringsKt.isBlank((CharSequence)endChainId) ? "[Model " + sunSpecModel.getId() + "]:" + sunSpecModel.getGroup().getLabel() : "[Model " + sunSpecModel.getId() + "]:" + sunSpecModel.getGroup().getLabel() + ": " + sunSpecModel.getGroup().getDescription();
                Block block = Block.Companion.builder().schemaDevice(schemaDevice).id("Model " + sunSpecModel.getId()).description(modelDescription).build();
                INSTANCE.addGroup(block, "", sunSpecModel.getGroup(), modelAddress, modelId, modelLength);
            }
            if (!schemaDevice.initialize()) {
                throw new ModbusException("Unable to initialize the schema device", null, 2, null);
            }
            if (!StringsKt.isBlank((CharSequence)description)) break block14;
            Block block = schemaDevice.get("Model 1");
            if (block != null) {
                Block it = block;
                boolean bl = false;
                Field manufacturer = it.get("Mn");
                Field model = it.get("Md");
                Field serialNr = it.get("SN");
                Field version = it.get("Vr");
                if (manufacturer == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (model == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (serialNr == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (version == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                manufacturer.need();
                model.need();
                serialNr.need();
                version.need();
                schemaDevice.update(1000L);
                schemaDevice.setDescription("A schema specifically for the SunSpec device made by " + manufacturer.getStringValue() + " model " + model.getStringValue() + " using version " + version.getStringValue() + " (SN: " + serialNr.getStringValue() + ")");
            }
        }
        return schemaDevice;
    }

    public static /* synthetic */ SchemaDevice generate$default(ModbusDevice modbusDevice, String string, int n, Object object) throws ModbusException {
        if ((n & 2) != 0) {
            string = "";
        }
        return SunspecDevice.generate(modbusDevice, string);
    }

    private final void addGroup(Block block, String prefix, Group group, Address thisModelAddress, int modelId, Integer modelLength) throws ModbusException {
        int pointCounter = 0;
        if (modelLength == null) {
            pointCounter = 3;
        }
        for (Point point : group.getPoints()) {
            Field field = this.createAndAddFieldToModel(block, thisModelAddress, point, prefix);
            switch (++pointCounter) {
                case 1: {
                    RegisterValue it;
                    if (this.getFirstRegisterValue(field) != null) {
                        boolean bl = false;
                        it.setComment("--------------------------------------\nModel " + modelId + " [Header @ " + it.getAddress().toCleanFormat() + "]: " + group.getLabel());
                    }
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    RegisterValue it;
                    if (this.getFirstRegisterValue(field) != null) {
                        boolean bl = false;
                        String string = it.getAddress().toCleanFormat();
                        Address address = it.getAddress();
                        Integer n = modelLength;
                        Intrinsics.checkNotNull((Object)n);
                        it.setComment("Model " + modelId + " [Data @ " + string + " - " + address.increment(n.intValue()).toCleanFormat() + "]: " + modelLength + " registers");
                    }
                    break;
                }
            }
        }
        for (Group subGroup : group.getGroups()) {
            String countString = subGroup.getCount();
            int count = 0;
            if (countString != null) {
                try {
                    count = Integer.parseInt(countString);
                }
                catch (NumberFormatException numberFormatException) {
                    Field countField;
                    if (block.getField(countString) == null) {
                        throw new ModbusException("Unable to find the count field named \"" + countString + "\" for this group", null, 2, null);
                    }
                    countField.update();
                    Long l = countField.getLongValue();
                    if (l == null) {
                        throw new ModbusException("Unable to read the value of the count field named \"" + countString + "\" for this group", null, 2, null);
                    }
                    long countValue = l;
                    count = Math.toIntExact(countValue);
                }
            }
            if (count == 0 && modelLength != null && group.getGroups().size() == 1) {
                if (group.getDataSize() == 0 || subGroup.getDataSize() == 0) {
                    throw new ModbusException("SunSpec repeat block problem", null, 2, null);
                }
                count = (2 + modelLength - group.getDataSize()) / subGroup.getDataSize();
                if (!(group.getDataSize() + subGroup.getDataSize() * count == modelLength)) {
                    boolean bl = false;
                    throw new ModbusException("SunSpec repeat block problem: " + group.getDataSize() + " + (" + subGroup.getDataSize() + " * " + count + ") == " + modelLength + ")", null, 2, null);
                }
            }
            String subGroupPrefix = prefix;
            if (((CharSequence)prefix).length() == 0) {
                subGroupPrefix = "R";
            }
            int n = count;
            for (int index = 0; index < n; ++index) {
                this.addGroup(block, subGroupPrefix + index + "_", subGroup, thisModelAddress.increment(2 + group.getDataSize() + index * subGroup.getDataSize()), modelId, null);
            }
        }
    }

    private final String mappingString(Point point) {
        StringBuilder mappingString = new StringBuilder();
        for (Symbol symbol : point.getSymbols()) {
            mappingString.append(" ; " + symbol.getValue() + "->'" + symbol.getCleanName() + "'");
        }
        String string = mappingString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getCamelCaseName(Point $this$getCamelCaseName) {
        return CodeGeneration.convertToCodeCompliantName((String)$this$getCamelCaseName.getName(), (boolean)true);
    }

    private final String getCamelCaseSfName(Point $this$getCamelCaseSfName) {
        String string;
        if ($this$getCamelCaseSfName.getScalingFactor() == null) {
            string = null;
        } else {
            String string2 = $this$getCamelCaseSfName.getScalingFactor();
            Intrinsics.checkNotNull((Object)string2);
            string = CodeGeneration.convertToCodeCompliantName((String)string2, (boolean)true);
        }
        return string;
    }

    private final Field createAndAddFieldToModel(Block block, Address modelBaseAddress, Point point, String prefix) {
        String functionName = null;
        Object additionalArguments = null;
        TypeMapping typeLoadingParameters = null;
        switch (WhenMappings.$EnumSwitchMapping$0[point.getType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                TypeMapping typeMapping = TYPE_MAPPINGS_NO_SYMBOLS.get(point.getType());
                Intrinsics.checkNotNull((Object)typeMapping);
                typeLoadingParameters = typeMapping;
                functionName = typeLoadingParameters.getFunctionName();
                additionalArguments = typeLoadingParameters.getNotImplemented();
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                if (point.getSymbols().isEmpty()) {
                    TypeMapping typeMapping = TYPE_MAPPINGS_NO_SYMBOLS.get(point.getType());
                    Intrinsics.checkNotNull((Object)typeMapping);
                    typeLoadingParameters = typeMapping;
                    functionName = typeLoadingParameters.getFunctionName();
                    additionalArguments = typeLoadingParameters.getNotImplemented();
                    break;
                }
                TypeMapping typeMapping = TYPE_MAPPINGS_WITH_SYMBOLS.get(point.getType());
                Intrinsics.checkNotNull((Object)typeMapping);
                typeLoadingParameters = typeMapping;
                functionName = typeLoadingParameters.getFunctionName();
                additionalArguments = typeLoadingParameters.getNotImplemented() + this.mappingString(point);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Field.FieldBuilder fieldBuilder = Field.Companion.builder().block(block).id(prefix + this.getCamelCaseName(point)).unit(point.getUnits()).immutable(point.getMutable() == Point.Mutable.IMMUTABLE);
        if (point.getType() == Point.Type.SUNSSF) {
            v3 = fieldBuilder.description("[" + block.getId() + "](" + point.getName() + "): Scaling factor");
        } else {
            String string;
            CharSequence charSequence = point.getLabel();
            if (charSequence == null || charSequence.length() == 0) {
                String string2 = block.getId();
                String string3 = point.getName();
                String string4 = point.getDescription();
                if (string4 == null) {
                    string4 = "";
                }
                string = "[" + string2 + "](" + string3 + "): " + string4;
            } else {
                String string5 = block.getId();
                String string6 = point.getLabel();
                String string7 = point.getDescription();
                if (string7 == null) {
                    string7 = "";
                }
                string = "[" + string5 + "](" + string6 + "): " + string7;
            }
            String label = string;
            v3 = fieldBuilder.description(label);
        }
        if (point.getType() == Point.Type.SUNSSF || point.getType() == Point.Type.PAD || point.isImmutable() && (Intrinsics.areEqual((Object)point.getName(), (Object)"ID") || Intrinsics.areEqual((Object)point.getName(), (Object)"L"))) {
            fieldBuilder.system(true).immutable(true);
        }
        Address registerAddress = modelBaseAddress.increment(point.getOffsetInGroup());
        String expression = functionName + "(" + registerAddress + (String)(point.getSize() == 1 ? "" : "#" + point.getSize()) + (String)additionalArguments + ")";
        String camelCaseSfName = this.getCamelCaseSfName(point);
        CharSequence charSequence = camelCaseSfName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            expression = expression + " * (10^" + camelCaseSfName + ")";
        }
        if (point.getType() == Point.Type.TIMESTAMP) {
            long y2kEpochOffset = Instant.parse("2000-01-01T00:00:00.000Z").toEpochMilli();
            expression = "(" + expression + "*1000+" + y2kEpochOffset + ")";
        }
        return fieldBuilder.expression(expression).build();
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        TYPE_MAPPINGS_NO_SYMBOLS = new TreeMap();
        TYPE_MAPPINGS_WITH_SYMBOLS = new TreeMap();
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.PAD, new TypeMapping("int16", ";0x8000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.SUNSSF, new TypeMapping("int16", ";0x8000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.INT_16, new TypeMapping("int16", ";0x8000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.INT_32, new TypeMapping("int32", ";0x8000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.INT_64, new TypeMapping("int64", ";0x8000 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.RAW_16, new TypeMapping("hexstring", null, 2, null));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.UINT_16, new TypeMapping("uint16", "; 0xFFFF ;0x8000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.UINT_32, new TypeMapping("uint32", "; 0xFFFF 0xFFFF ;0x8000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.UINT_64, new TypeMapping("uint64", "; 0xFFFF 0xFFFF 0xFFFF 0xFFFF ;0x8000 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.TIMESTAMP, new TypeMapping("uint32", "; 0xFFFF 0xFFFF ;0x8000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.COUNT, new TypeMapping("uint16", "; 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.ACC_16, new TypeMapping("uint16", "; 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.ACC_32, new TypeMapping("uint32", "; 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.ACC_64, new TypeMapping("uint64", "; 0x0000 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.FLOAT_32, new TypeMapping("ieee754_32", "; 0x7FC0 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.FLOAT_64, new TypeMapping("ieee754_64", "; 0x7FF8 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.STRING, new TypeMapping("utf8", null, 2, null));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.IPADDR, new TypeMapping("ipv4addr", "; 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.IPV_6_ADDR, new TypeMapping("ipv6addr", "; 0x0000 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.EUI_48, new TypeMapping("eui48", "; 0x0000 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.ENUM_16, new TypeMapping("uint16", "; 0xFFFF"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.ENUM_32, new TypeMapping("uint32", "; 0xFFFF 0xFFFF"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.BITFIELD_16, new TypeMapping("uint16", "; 0xFFFF"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.BITFIELD_32, new TypeMapping("uint32", "; 0xFFFF 0xFFFF"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.BITFIELD_64, new TypeMapping("uint64", "; 0xFFFF 0xFFFF 0xFFFF 0xFFFF"));
        TYPE_MAPPINGS_WITH_SYMBOLS.put(Point.Type.ENUM_16, new TypeMapping("enum", "; 0xFFFF"));
        TYPE_MAPPINGS_WITH_SYMBOLS.put(Point.Type.ENUM_32, new TypeMapping("enum", "; 0xFFFF 0xFFFF"));
        TYPE_MAPPINGS_WITH_SYMBOLS.put(Point.Type.BITFIELD_16, new TypeMapping("bitset", "; 0xFFFF"));
        TYPE_MAPPINGS_WITH_SYMBOLS.put(Point.Type.BITFIELD_32, new TypeMapping("bitset", "; 0xFFFF 0xFFFF ; 0x8000 0xFFFF"));
        TYPE_MAPPINGS_WITH_SYMBOLS.put(Point.Type.BITFIELD_64, new TypeMapping("bitset", "; 0xFFFF 0xFFFF 0xFFFF 0xFFFF"));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lnl/basjes/sunspec/device/SunspecDevice$TypeMapping;", "", "functionName", "", "notImplemented", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getFunctionName", "()Ljava/lang/String;", "getNotImplemented", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "sunspec-device"})
    public static final class TypeMapping {
        @NotNull
        private final String functionName;
        @NotNull
        private final String notImplemented;

        public TypeMapping(@NotNull String functionName, @NotNull String notImplemented) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)notImplemented, (String)"notImplemented");
            this.functionName = functionName;
            this.notImplemented = notImplemented;
        }

        public /* synthetic */ TypeMapping(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            this(string, string2);
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        @NotNull
        public final String getNotImplemented() {
            return this.notImplemented;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        @NotNull
        public final String component2() {
            return this.notImplemented;
        }

        @NotNull
        public final TypeMapping copy(@NotNull String functionName, @NotNull String notImplemented) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)notImplemented, (String)"notImplemented");
            return new TypeMapping(functionName, notImplemented);
        }

        public static /* synthetic */ TypeMapping copy$default(TypeMapping typeMapping, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = typeMapping.functionName;
            }
            if ((n & 2) != 0) {
                string2 = typeMapping.notImplemented;
            }
            return typeMapping.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "TypeMapping(functionName=" + this.functionName + ", notImplemented=" + this.notImplemented + ")";
        }

        public int hashCode() {
            int result = this.functionName.hashCode();
            result = result * 31 + this.notImplemented.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeMapping)) {
                return false;
            }
            TypeMapping typeMapping = (TypeMapping)other;
            if (!Intrinsics.areEqual((Object)this.functionName, (Object)typeMapping.functionName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.notImplemented, (Object)typeMapping.notImplemented);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Point.Type.values().length];
            try {
                nArray[Point.Type.PAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.SUNSSF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.INT_16.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.INT_32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.INT_64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.RAW_16.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.UINT_16.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.UINT_32.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.UINT_64.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.COUNT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.ACC_16.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.ACC_32.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.ACC_64.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.FLOAT_32.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.FLOAT_64.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.STRING.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.IPADDR.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.IPV_6_ADDR.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.EUI_48.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.TIMESTAMP.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.BITFIELD_16.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.BITFIELD_32.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.BITFIELD_64.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.ENUM_16.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.ENUM_32.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

