/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.sunspec.device;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.BlockKt;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.SchemaDeviceKt;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaParseException;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.utils.StringTable;
import nl.basjes.sunspec.device.SunSpecDeviceModelFinder;
import nl.basjes.sunspec.device.Utils;
import nl.basjes.sunspec.model.SunSpec;
import nl.basjes.sunspec.model.entities.Group;
import nl.basjes.sunspec.model.entities.Point;
import nl.basjes.sunspec.model.entities.SunSpecModel;
import nl.basjes.sunspec.model.entities.Symbol;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001=B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0019\u001a\u00020\u001aJU\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u0016H\u0002\u00a2\u0006\u0002\u0010&J\u001a\u0010'\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010(\u001a\u0004\u0018\u00010\rH\u0002JU\u0010)\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010*\u001a\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u0016H\u0002\u00a2\u0006\u0002\u0010+J(\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010.\u001a\u00020\u001cH\u0002J\u0010\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u000201H\u0002J6\u00106\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u001c2\u0006\u00100\u001a\u0002012\u0006\u0010#\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001a\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;09X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;09X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lnl/basjes/sunspec/device/SunspecDevice;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "getFirstRegisterValue", "Lnl/basjes/modbus/device/api/RegisterValue;", "field", "Lnl/basjes/modbus/schema/Field;", "setCommentOnFirstRegisterValue", "", "comment", "", "generate", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "description", "skipUnknownModels", "", "collectPointNamesThatAreReferenced", "", "model", "Lnl/basjes/sunspec/model/entities/SunSpecModel;", "group", "Lnl/basjes/sunspec/model/entities/Group;", "addGroupPoints", "Lnl/basjes/modbus/device/api/Address;", "startFieldAddress", "block", "Lnl/basjes/modbus/schema/Block;", "modelId", "", "modelLength", "prefix", "addComments", "pointNamesThatAreReferenced", "(Lnl/basjes/sunspec/model/entities/Group;Lnl/basjes/modbus/device/api/Address;Lnl/basjes/modbus/schema/Block;ILjava/lang/Integer;Ljava/lang/String;ZLjava/util/List;)Lnl/basjes/modbus/device/api/Address;", "determineCount", "countString", "addGroup", "isRootGroup", "(Lnl/basjes/modbus/schema/Block;Ljava/lang/String;Lnl/basjes/sunspec/model/entities/Group;Lnl/basjes/modbus/device/api/Address;ILjava/lang/Integer;ZLjava/util/List;)Lnl/basjes/modbus/device/api/Address;", "createBlockForNonExistentModel", "schemaDevice", "modelAddress", "mappingString", "point", "Lnl/basjes/sunspec/model/entities/Point;", "y2kEpochOffset", "", "getY2kEpochOffset", "()J", "createAndAddFieldToModel", "registerAddress", "TYPE_MAPPINGS_NO_SYMBOLS", "", "Lnl/basjes/sunspec/model/entities/Point$Type;", "Lnl/basjes/sunspec/device/SunspecDevice$TypeMapping;", "TYPE_MAPPINGS_WITH_SYMBOLS", "TypeMapping", "sunspec-device"})
@SourceDebugExtension(value={"SMAP\nSunspecDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SunspecDevice.kt\nnl/basjes/sunspec/device/SunspecDevice\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,671:1\n1#2:672\n774#3:673\n865#3,2:674\n774#3:676\n865#3,2:677\n774#3:679\n865#3,2:680\n1869#3,2:682\n1563#3:684\n1634#3,3:685\n1869#3,2:688\n*S KotlinDebug\n*F\n+ 1 SunspecDevice.kt\nnl/basjes/sunspec/device/SunspecDevice\n*L\n295#1:673\n295#1:674,2\n296#1:676\n296#1:677,2\n300#1:679\n300#1:680,2\n300#1:682,2\n302#1:684\n302#1:685,3\n302#1:688,2\n*E\n"})
public final class SunspecDevice {
    @NotNull
    public static final SunspecDevice INSTANCE = new SunspecDevice();
    @NotNull
    private static final Logger LOG;
    private static final long y2kEpochOffset;
    @NotNull
    private static final Map<Point.Type, TypeMapping> TYPE_MAPPINGS_NO_SYMBOLS;
    @NotNull
    private static final Map<Point.Type, TypeMapping> TYPE_MAPPINGS_WITH_SYMBOLS;

    private SunspecDevice() {
    }

    private final RegisterValue getFirstRegisterValue(Field field) {
        field.initialize();
        Expression expression = field.getParsedExpression();
        if (expression == null) {
            return null;
        }
        Expression parsedExpression = expression;
        List modbusValues = parsedExpression.getModbusValues(field.getBlock().getSchemaDevice());
        if (modbusValues.isEmpty()) {
            return null;
        }
        ModbusValue registerValue = (ModbusValue)modbusValues.get(0);
        if (!(registerValue instanceof RegisterValue)) {
            boolean bl = false;
            String string = "The expression " + parsedExpression + " returned a " + registerValue.getClass().getName() + " instance instead of a " + RegisterValue.class.getName() + " instance.";
            throw new IllegalArgumentException(string.toString());
        }
        return (RegisterValue)registerValue;
    }

    private final void setCommentOnFirstRegisterValue(Field field, String comment) {
        block0: {
            RegisterValue registerValue = this.getFirstRegisterValue(field);
            if (registerValue == null) break block0;
            registerValue.setComment(comment);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final SchemaDevice generate(@NotNull ModbusDevice modbusDevice, @NotNull String description, boolean skipUnknownModels) throws ModbusException {
        SchemaDevice schemaDevice;
        block26: {
            Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            SunSpec sunSpec = new SunSpec();
            List<SunSpecDeviceModelFinder.DeviceSunSpecModel> deviceSunSpecModels = SunSpecDeviceModelFinder.INSTANCE.findDeviceSunSpecModels(modbusDevice);
            if (deviceSunSpecModels.isEmpty()) {
                LOG.error("Unable to find any SunSpec models");
                return null;
            }
            StringTable table = new StringTable();
            String[] stringArray = new String[]{"Model", "Address", "Length", "Label"};
            table.withHeaders(stringArray);
            for (SunSpecDeviceModelFinder.DeviceSunSpecModel deviceSunSpecModel : deviceSunSpecModels) {
                StringTable stringTable;
                String[] stringArray2;
                SunSpecModel model = sunSpec.getModel(deviceSunSpecModel.getId());
                if (model == null) {
                    stringArray2 = new String[]{String.valueOf(deviceSunSpecModel.getId()), deviceSunSpecModel.getAddress().toCleanFormat(), String.valueOf(deviceSunSpecModel.getRegisters()), "Non existent model"};
                    stringTable = table.addRow(stringArray2);
                    continue;
                }
                stringArray2 = new String[4];
                stringArray2[0] = String.valueOf(deviceSunSpecModel.getId());
                stringArray2[1] = deviceSunSpecModel.getAddress().toCleanFormat();
                stringArray2[2] = String.valueOf(deviceSunSpecModel.getRegisters());
                String string = model.getCleanLabel();
                if (string == null) {
                    string = "";
                }
                stringArray2[3] = string;
                stringTable = table.addRow(stringArray2);
            }
            LOG.info("Detected models: \n{}", (Object)table);
            schemaDevice = new SchemaDevice(description, 0, 2, null);
            SchemaDevice.connect$default((SchemaDevice)schemaDevice, (ModbusDevice)modbusDevice, (int)0, (int)2, null);
            for (SunSpecDeviceModelFinder.DeviceSunSpecModel deviceSunSpecModel : deviceSunSpecModels) {
                String subGroupCount;
                String string;
                CharSequence endChainId;
                int modelId = deviceSunSpecModel.getId();
                int modelLength = deviceSunSpecModel.getRegisters();
                Address modelAddress = deviceSunSpecModel.getAddress();
                if (modelId == 0) {
                    Field sunSHeaderBlock = Utils.INSTANCE.addSunSHeaderBlock(schemaDevice, deviceSunSpecModel.getAddress());
                    INSTANCE.setCommentOnFirstRegisterValue(sunSHeaderBlock, "--------------------------------------\nSunS header");
                    continue;
                }
                if (modelId == 65535) {
                    Block endChainBlock = Utils.INSTANCE.addSunSpecEndOfChainBlock(schemaDevice);
                    endChainId = (Field)Utils.INSTANCE.addModelHeaderFields(endChainBlock, modelAddress).component1();
                    INSTANCE.setCommentOnFirstRegisterValue((Field)endChainId, "--------------------------------------\nNO MORE MODELS");
                    break;
                }
                SunSpecModel sunSpecModel = sunSpec.getModel(modelId);
                if (sunSpecModel == null) {
                    LOG.fatal("Unable to get model for ID: {}", (Object)modelId);
                    if (skipUnknownModels) continue;
                    INSTANCE.createBlockForNonExistentModel(schemaDevice, modelId, modelLength, modelAddress);
                    continue;
                }
                endChainId = sunSpecModel.getCleanDescription();
                if (endChainId == null || StringsKt.isBlank((CharSequence)endChainId)) {
                    int n = sunSpecModel.getId();
                    String string2 = sunSpecModel.getGroup().getLabel();
                    if (string2 == null) {
                        string2 = "Undocumented model";
                    }
                    string = "[Model " + n + "]: " + string2;
                } else {
                    string = "[Model " + sunSpecModel.getId() + "]: " + sunSpecModel.getGroup().getDescription();
                }
                String modelDescription = string;
                Block.BlockBuilder blockBuilder = Block.Companion.builder().schemaDevice(schemaDevice).id("Model " + sunSpecModel.getId()).description(modelDescription);
                String blockLabel = sunSpecModel.getCleanLabel();
                CharSequence charSequence = blockLabel;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    blockBuilder.shortDescription(blockLabel);
                }
                Block block = blockBuilder.build();
                List<String> pointNamesThatAreReferenced = INSTANCE.collectPointNamesThatAreReferenced(sunSpecModel);
                String string3 = subGroupCount = sunSpecModel.getGroup().getGroups().size() == 1 ? ((Group)sunSpecModel.getGroup().getGroups().get(0)).getCount() : "Computer says no";
                if (subGroupCount == null || Intrinsics.areEqual((Object)subGroupCount, (Object)"0")) {
                    Group subGroup = (Group)sunSpecModel.getGroup().getGroups().get(0);
                    if (subGroup.getDataSize() == 0) {
                        throw new ModbusException("SunSpec repeat block problem", null, 2, null);
                    }
                    int count = (modelLength - sunSpecModel.getGroup().getDataSize()) / subGroup.getDataSize();
                    if (!(sunSpecModel.getGroup().getDataSize() + subGroup.getDataSize() * count == modelLength)) {
                        boolean bl = false;
                        throw new ModbusException("SunSpec repeat block problem: " + sunSpecModel.getGroup().getDataSize() + " + (" + subGroup.getDataSize() + " * " + count + ") == " + modelLength + ")", null, 2, null);
                    }
                    Address nextFieldAddress = INSTANCE.addGroupPoints(sunSpecModel.getGroup(), modelAddress, block, modelId, modelLength, "", true, pointNamesThatAreReferenced);
                    for (int subGroupIndex = 0; subGroupIndex < count; ++subGroupIndex) {
                        String string4;
                        SunspecDevice sunspecDevice = INSTANCE;
                        Block block2 = block;
                        String string5 = subGroup.getName();
                        if (((CharSequence)string5).length() > 0) {
                            String string6;
                            void it;
                            char c = string5.charAt(0);
                            StringBuilder stringBuilder = new StringBuilder();
                            Block block3 = block2;
                            SunspecDevice sunspecDevice2 = sunspecDevice;
                            boolean bl = false;
                            if (Character.isLowerCase((char)it)) {
                                Locale locale = Locale.getDefault();
                                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                                string6 = CharsKt.titlecase((char)it, (Locale)locale);
                            } else {
                                string6 = String.valueOf((char)it);
                            }
                            CharSequence charSequence2 = string6;
                            sunspecDevice = sunspecDevice2;
                            block2 = block3;
                            StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence2);
                            String string7 = string5;
                            int n = 1;
                            String string8 = string7.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                            string4 = stringBuilder2.append(string8).toString();
                        } else {
                            string4 = string5;
                        }
                        nextFieldAddress = sunspecDevice.addGroup(block2, string4 + "_" + subGroupIndex + "_", subGroup, nextFieldAddress, modelId, null, false, pointNamesThatAreReferenced);
                    }
                    continue;
                }
                INSTANCE.addGroup(block, "", sunSpecModel.getGroup(), modelAddress, modelId, modelLength, true, pointNamesThatAreReferenced);
            }
            if (!schemaDevice.initialize()) {
                throw new ModbusException("Unable to initialize the schema device", null, 2, null);
            }
            if (!StringsKt.isBlank((CharSequence)description)) break block26;
            Block block = SchemaDeviceKt.get((SchemaDevice)schemaDevice, (String)"Model 1");
            if (block != null) {
                String string;
                Block it = block;
                boolean bl = false;
                Field manufacturer = BlockKt.get((Block)it, (String)"Manufacturer");
                Field model = BlockKt.get((Block)it, (String)"Model");
                Field serialNr = BlockKt.get((Block)it, (String)"Serial Number");
                Field version = BlockKt.get((Block)it, (String)"Version");
                if (manufacturer == null) {
                    string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (model == null) {
                    string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (serialNr == null) {
                    string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (version == null) {
                    string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                manufacturer.need();
                model.need();
                serialNr.need();
                version.need();
                schemaDevice.update(100000L);
                schemaDevice.setDescription("A schema specifically for the SunSpec device made by " + manufacturer.getStringValue() + " model " + model.getStringValue() + " using version " + version.getStringValue() + " (SN: " + serialNr.getStringValue() + ")");
            }
        }
        return schemaDevice;
    }

    public static /* synthetic */ SchemaDevice generate$default(ModbusDevice modbusDevice, String string, boolean bl, int n, Object object) throws ModbusException {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return SunspecDevice.generate(modbusDevice, string, bl);
    }

    @NotNull
    public final List<String> collectPointNamesThatAreReferenced(@NotNull SunSpecModel model) {
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Iterable $this$filter$iv = CollectionsKt.distinct((Iterable)this.collectPointNamesThatAreReferenced(model.getGroup()));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            if (!new Regex("[A-Za-z]").containsMatchIn(charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> collectPointNamesThatAreReferenced(@NotNull Group group) {
        void $this$mapTo$iv$iv;
        Object it;
        Point it2;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        List pointNames = new ArrayList();
        Iterable $this$filter$iv = group.getPoints();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it2 = (Point)element$iv$iv;
            boolean bl = false;
            if (!(it2.getType() == Point.Type.SUNSSF)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Point it3 = (Point)element$iv;
            boolean bl = false;
            pointNames.add(it3.getName());
        }
        String string = group.getCount();
        if (string != null) {
            it = string;
            boolean bl = false;
            pointNames.add(it);
        }
        Iterable $this$map$iv = group.getGroups();
        boolean $i$f$map = false;
        it = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (Group)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.collectPointNamesThatAreReferenced((Group)it2));
        }
        $this$forEach$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it4 = (String)element$iv;
            boolean bl = false;
            pointNames.add(it4);
        }
        return pointNames;
    }

    private final Address addGroupPoints(Group group, Address startFieldAddress, Block block, int modelId, Integer modelLength, String prefix, boolean addComments, List<String> pointNamesThatAreReferenced) {
        boolean bl;
        Address nextFieldAddress = startFieldAddress;
        int pointNrInModel = 0;
        boolean didFirstDataComment = false;
        if (group.getType() == Group.Type.SYNC) {
            if (!((Collection)group.getGroups()).isEmpty()) {
                throw new ModbusSchemaParseException("It is impossible to do a SunSpec SYNC if there are sub groups");
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean forceFetchGroup = bl;
        String fetchGroupId = "<<Group SYNC for " + group.getName() + " at " + nextFieldAddress.toCleanFormat() + ">>";
        for (Point point : group.getPoints()) {
            RegisterValue it;
            ++pointNrInModel;
            Field field = this.createAndAddFieldToModel(block, nextFieldAddress, point, prefix, pointNamesThatAreReferenced);
            if (forceFetchGroup) {
                field.setFetchGroup(fetchGroupId);
            }
            nextFieldAddress = nextFieldAddress.increment(point.getSize());
            if (!addComments) continue;
            if (point.isModelHeader()) {
                if (!Intrinsics.areEqual((Object)point.getName(), (Object)"ID")) continue;
                if (this.getFirstRegisterValue(field) != null) {
                    boolean bl2 = false;
                    it.setComment("--------------------------------------\nModel " + modelId + " [Header @ " + it.getAddress().toCleanFormat() + "]: " + group.getLabel());
                }
                continue;
            }
            if (didFirstDataComment) continue;
            didFirstDataComment = true;
            if (this.getFirstRegisterValue(field) == null) continue;
            boolean bl3 = false;
            Integer n = modelLength;
            it.setComment("Model " + modelId + " [Data @ " + it.getAddress().toCleanFormat() + " - " + it.getAddress().increment((n != null ? n : 1) - 1).toCleanFormat() + "]: " + modelLength + " registers");
        }
        return nextFieldAddress;
    }

    private final int determineCount(Block block, String countString) {
        CharSequence charSequence = countString;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return 1;
        }
        try {
            return Integer.parseInt(countString);
        }
        catch (NumberFormatException numberFormatException) {
            Field field = block.getField(countString);
            if (field == null) {
                throw new ModbusException("Unable to find the count field named \"" + countString + "\" for this group in \"" + block.getId() + "\"", null, 2, null);
            }
            Field countField = field;
            countField.initialize();
            countField.update();
            Long l = countField.getLongValue();
            if (l == null) {
                throw new ModbusException("Unable to read the value of the count field named \"" + countString + "\" for this group", null, 2, null);
            }
            long countValue = l;
            return Math.toIntExact(countValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Address addGroup(Block block, String prefix, Group group, Address startFieldAddress, int modelId, Integer modelLength, boolean isRootGroup, List<String> pointNamesThatAreReferenced) throws ModbusException {
        Address nextFieldAddress = this.addGroupPoints(group, startFieldAddress, block, modelId, modelLength, prefix, isRootGroup, pointNamesThatAreReferenced);
        if (group.getGroups().isEmpty()) {
            return nextFieldAddress;
        }
        int subGroupIndex = 0;
        for (Group subGroup : group.getGroups()) {
            String string;
            int count = this.determineCount(block, subGroup.getCount());
            String string2 = prefix;
            String string3 = subGroup.getName();
            if (((CharSequence)string3).length() > 0) {
                String string4;
                void it;
                char c = string3.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                String string5 = string2;
                boolean bl = false;
                if (Character.isLowerCase((char)it)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string4 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string4 = String.valueOf((char)it);
                }
                CharSequence charSequence = string4;
                string2 = string5;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                String string6 = string3;
                int n = 1;
                String string7 = string6.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                string = stringBuilder2.append(string7).toString();
            } else {
                string = string3;
            }
            String prefix2 = string2 + string;
            for (int index = 0; index < count; ++index) {
                nextFieldAddress = this.addGroup(block, subGroup.getCount() == null ? prefix2 + "_" : prefix2 + "_" + index + "_", subGroup, nextFieldAddress, modelId, null, false, pointNamesThatAreReferenced);
            }
            ++subGroupIndex;
        }
        return nextFieldAddress;
    }

    private final void createBlockForNonExistentModel(SchemaDevice schemaDevice, int modelId, int modelLength, Address modelAddress) {
        int registersForField;
        RegisterValue it;
        Block block = Block.Companion.builder().schemaDevice(schemaDevice).id("Model " + modelId).description("[Model " + modelId + "]: Unknown (vendor specific?) model. No fields available.").shortDescription("Unknown model: " + modelId + ".").build();
        Field modelIdField = (Field)Utils.INSTANCE.addModelHeaderFields(block, modelAddress).component1();
        RegisterValue registerValue = this.getFirstRegisterValue(modelIdField);
        if (registerValue != null) {
            it = registerValue;
            boolean bl = false;
            it.setComment("--------------------------------------\nModel " + modelId + " [Header @ " + it.getAddress().toCleanFormat() + "]: Unknown (vendor specific?) model. No fields available.");
        }
        Address unknownAddress = modelAddress.increment(2);
        it = block.getSchemaDevice().getModbusBlock(unknownAddress.getAddressClass()).get(unknownAddress);
        boolean bl = false;
        it.setComment("Model " + modelId + " [Data @ " + it.getAddress().toCleanFormat() + " - " + it.getAddress().increment(modelLength - 1).toCleanFormat() + "]: " + modelLength + " registers");
        int remainingRegisters = modelLength;
        int index = 0;
        do {
            registersForField = remainingRegisters > 125 ? 125 : remainingRegisters;
            Field.Companion.builder().block(block).id("Unknown_" + index).description("Unknown block of registers #" + index).expression("hexstring(" + unknownAddress.toCleanFormat() + "#" + registersForField + ")").build();
            ++index;
            unknownAddress = unknownAddress.increment(registersForField);
        } while ((remainingRegisters -= registersForField) > 125);
    }

    private final String mappingString(Point point) {
        StringBuilder mappingString = new StringBuilder();
        for (Symbol symbol : point.getSymbols()) {
            mappingString.append(" ; " + symbol.getValue() + "->'" + symbol.getCleanName() + "'");
        }
        String string = mappingString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final long getY2kEpochOffset() {
        return y2kEpochOffset;
    }

    private final Field createAndAddFieldToModel(Block block, Address registerAddress, Point point, String prefix, List<String> pointNamesThatAreReferenced) {
        Field.FieldBuilder fieldBuilder;
        String string;
        Object object;
        CharSequence charSequence;
        String functionName = null;
        Object additionalArguments = null;
        TypeMapping typeLoadingParameters = null;
        switch (WhenMappings.$EnumSwitchMapping$0[point.getType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                TypeMapping typeMapping = TYPE_MAPPINGS_NO_SYMBOLS.get(point.getType());
                Intrinsics.checkNotNull((Object)typeMapping);
                typeLoadingParameters = typeMapping;
                functionName = typeLoadingParameters.getFunctionName();
                additionalArguments = typeLoadingParameters.getNotImplemented();
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                if (point.getSymbols().isEmpty()) {
                    TypeMapping typeMapping = TYPE_MAPPINGS_NO_SYMBOLS.get(point.getType());
                    Intrinsics.checkNotNull((Object)typeMapping);
                    typeLoadingParameters = typeMapping;
                    functionName = typeLoadingParameters.getFunctionName();
                    additionalArguments = typeLoadingParameters.getNotImplemented();
                    break;
                }
                TypeMapping typeMapping = TYPE_MAPPINGS_WITH_SYMBOLS.get(point.getType());
                Intrinsics.checkNotNull((Object)typeMapping);
                typeLoadingParameters = typeMapping;
                functionName = typeLoadingParameters.getFunctionName();
                additionalArguments = typeLoadingParameters.getNotImplemented() + this.mappingString(point);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Field.FieldBuilder fieldBuilder2 = Field.Companion.builder().block(block).immutable(point.getMutable() == Point.Mutable.IMMUTABLE);
        String label = point.getLabel();
        if (!pointNamesThatAreReferenced.contains(point.getName()) && point.getType() != Point.Type.SUNSSF && !((charSequence = (CharSequence)label) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            charSequence = StringsKt.replace$default((String)label, (String)"-", (String)" ", (boolean)false, (int)4, null);
            object = new Regex("[^A-Za-z0-9 _]");
            String string2 = " ";
            charSequence = object.replace(charSequence, string2);
            object = new Regex(" +");
            string2 = " ";
            string = ((Object)StringsKt.trim((CharSequence)object.replace(charSequence, string2))).toString();
        } else {
            string = point.getName();
        }
        fieldBuilder2.id(prefix + ((Object)StringsKt.trim((CharSequence)string)).toString());
        charSequence = point.getUnits();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            fieldBuilder2.unit(point.getUnits());
        }
        if (point.getType() == Point.Type.SUNSSF) {
            fieldBuilder = fieldBuilder2.description("Scaling factor");
        } else {
            String string3;
            String string4 = point.getLabel();
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                fieldBuilder2.shortDescription(it);
            }
            if ((string3 = point.getDescription()) == null && (string3 = point.getLabel()) == null) {
                string3 = point.getName();
            }
            String description = string3;
            fieldBuilder = point.getType() == Point.Type.TIMESTAMP ? fieldBuilder2.description(description + " Converted to standard UNIX Epoch in Milliseconds.") : fieldBuilder2.description(description);
        }
        if (point.getType() == Point.Type.SUNSSF || point.getType() == Point.Type.PAD || point.isModelHeader()) {
            fieldBuilder2.system(true).immutable(true);
        }
        String expression = functionName + "(" + registerAddress + (String)(point.getSize() == 1 ? "" : "#" + point.getSize()) + (String)additionalArguments + ")";
        object = point.getScalingFactor();
        if (!(object == null || object.length() == 0)) {
            expression = expression + " * (10^" + point.getScalingFactor() + ")";
        }
        if (point.getType() == Point.Type.TIMESTAMP) {
            expression = "(" + expression + "*1000+" + y2kEpochOffset + ")";
        }
        return fieldBuilder2.expression(expression).build();
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        y2kEpochOffset = Instant.parse("2000-01-01T00:00:00.000Z").toEpochMilli();
        TYPE_MAPPINGS_NO_SYMBOLS = new TreeMap();
        TYPE_MAPPINGS_WITH_SYMBOLS = new TreeMap();
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.PAD, new TypeMapping("int16", ";0x8000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.SUNSSF, new TypeMapping("int16", ";0x8000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.INT_16, new TypeMapping("int16", ";0x8000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.INT_32, new TypeMapping("int32", ";0x8000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.INT_64, new TypeMapping("int64", ";0x8000 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.RAW_16, new TypeMapping("hexstring", null, 2, null));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.UINT_16, new TypeMapping("uint16", "; 0xFFFF ;0x8000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.UINT_32, new TypeMapping("uint32", "; 0xFFFF 0xFFFF ;0x8000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.UINT_64, new TypeMapping("uint64", "; 0xFFFF 0xFFFF 0xFFFF 0xFFFF ;0x8000 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.TIMESTAMP, new TypeMapping("uint32", "; 0xFFFF 0xFFFF ;0x8000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.COUNT, new TypeMapping("uint16", "; 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.ACC_16, new TypeMapping("uint16", "; 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.ACC_32, new TypeMapping("uint32", "; 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.ACC_64, new TypeMapping("uint64", "; 0x0000 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.FLOAT_32, new TypeMapping("ieee754_32", "; 0x7FC0 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.FLOAT_64, new TypeMapping("ieee754_64", "; 0x7FF8 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.STRING, new TypeMapping("utf8", null, 2, null));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.IPADDR, new TypeMapping("ipv4addr", "; 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.IPV_6_ADDR, new TypeMapping("ipv6addr", "; 0x0000 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.EUI_48, new TypeMapping("eui48", "; 0x0000 0x0000 0x0000 0x0000"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.ENUM_16, new TypeMapping("uint16", "; 0xFFFF"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.ENUM_32, new TypeMapping("uint32", "; 0xFFFF 0xFFFF"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.BITFIELD_16, new TypeMapping("bitset", "; 0xFFFF"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.BITFIELD_32, new TypeMapping("bitset", "; 0xFFFF 0xFFFF"));
        TYPE_MAPPINGS_NO_SYMBOLS.put(Point.Type.BITFIELD_64, new TypeMapping("bitset", "; 0xFFFF 0xFFFF 0xFFFF 0xFFFF"));
        TYPE_MAPPINGS_WITH_SYMBOLS.put(Point.Type.ENUM_16, new TypeMapping("enum", "; 0xFFFF"));
        TYPE_MAPPINGS_WITH_SYMBOLS.put(Point.Type.ENUM_32, new TypeMapping("enum", "; 0xFFFF 0xFFFF"));
        TYPE_MAPPINGS_WITH_SYMBOLS.put(Point.Type.BITFIELD_16, new TypeMapping("bitset", "; 0xFFFF"));
        TYPE_MAPPINGS_WITH_SYMBOLS.put(Point.Type.BITFIELD_32, new TypeMapping("bitset", "; 0xFFFF 0xFFFF ; 0x8000 0xFFFF"));
        TYPE_MAPPINGS_WITH_SYMBOLS.put(Point.Type.BITFIELD_64, new TypeMapping("bitset", "; 0xFFFF 0xFFFF 0xFFFF 0xFFFF"));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lnl/basjes/sunspec/device/SunspecDevice$TypeMapping;", "", "functionName", "", "notImplemented", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getFunctionName", "()Ljava/lang/String;", "getNotImplemented", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "sunspec-device"})
    public static final class TypeMapping {
        @NotNull
        private final String functionName;
        @NotNull
        private final String notImplemented;

        public TypeMapping(@NotNull String functionName, @NotNull String notImplemented) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)notImplemented, (String)"notImplemented");
            this.functionName = functionName;
            this.notImplemented = notImplemented;
        }

        public /* synthetic */ TypeMapping(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            this(string, string2);
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        @NotNull
        public final String getNotImplemented() {
            return this.notImplemented;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        @NotNull
        public final String component2() {
            return this.notImplemented;
        }

        @NotNull
        public final TypeMapping copy(@NotNull String functionName, @NotNull String notImplemented) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)notImplemented, (String)"notImplemented");
            return new TypeMapping(functionName, notImplemented);
        }

        public static /* synthetic */ TypeMapping copy$default(TypeMapping typeMapping, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = typeMapping.functionName;
            }
            if ((n & 2) != 0) {
                string2 = typeMapping.notImplemented;
            }
            return typeMapping.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "TypeMapping(functionName=" + this.functionName + ", notImplemented=" + this.notImplemented + ")";
        }

        public int hashCode() {
            int result = this.functionName.hashCode();
            result = result * 31 + this.notImplemented.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeMapping)) {
                return false;
            }
            TypeMapping typeMapping = (TypeMapping)other;
            if (!Intrinsics.areEqual((Object)this.functionName, (Object)typeMapping.functionName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.notImplemented, (Object)typeMapping.notImplemented);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Point.Type.values().length];
            try {
                nArray[Point.Type.PAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.SUNSSF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.INT_16.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.INT_32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.INT_64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.RAW_16.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.UINT_16.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.UINT_32.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.UINT_64.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.COUNT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.ACC_16.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.ACC_32.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.ACC_64.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.FLOAT_32.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.FLOAT_64.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.STRING.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.IPADDR.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.IPV_6_ADDR.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.EUI_48.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.TIMESTAMP.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.BITFIELD_16.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.BITFIELD_32.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.BITFIELD_64.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.ENUM_16.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Point.Type.ENUM_32.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

