/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.sunspec.device;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.sunspec.ConstantsKt;
import nl.basjes.sunspec.device.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnl/basjes/sunspec/device/SunSpecDeviceModelFinder;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "findDeviceSunSpecModels", "", "Lnl/basjes/sunspec/device/SunSpecDeviceModelFinder$DeviceSunSpecModel;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "findSunSpecDevice", "Lkotlin/Pair;", "Lnl/basjes/modbus/device/api/Address;", "Lnl/basjes/modbus/schema/SchemaDevice;", "DeviceSunSpecModel", "sunspec-device"})
public final class SunSpecDeviceModelFinder {
    @NotNull
    public static final SunSpecDeviceModelFinder INSTANCE = new SunSpecDeviceModelFinder();
    @NotNull
    private static final Logger LOG;

    private SunSpecDeviceModelFinder() {
    }

    @NotNull
    public final List<DeviceSunSpecModel> findDeviceSunSpecModels(@NotNull ModbusDevice modbusDevice) throws ModbusException {
        Address thisModelAddress;
        int modelLength;
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        List models = new ArrayList();
        Pair<Address, SchemaDevice> pair = this.findSunSpecDevice(modbusDevice);
        Address sunSpecStartAddress = (Address)pair.component1();
        SchemaDevice schemaDevice = (SchemaDevice)pair.component2();
        models.add(new DeviceSunSpecModel(sunSpecStartAddress, 0, 0));
        Address nextModelAddress = sunSpecStartAddress.increment(2);
        while (true) {
            Block.BlockBuilder blockBuilder = Block.Companion.builder();
            SchemaDevice schemaDevice2 = schemaDevice;
            Intrinsics.checkNotNull((Object)schemaDevice2);
            Block readModelHeaderBlock = blockBuilder.schemaDevice(schemaDevice2).id("Block_at_" + nextModelAddress.toModiconX()).description("Model Header at " + nextModelAddress).build();
            Pair<Field, Field> pair2 = Utils.INSTANCE.addModelHeaderFields(readModelHeaderBlock, nextModelAddress);
            Field readModelIdField = (Field)pair2.component1();
            Field readModelLengthField = (Field)pair2.component2();
            schemaDevice.updateAll(1000000L);
            Long longModelId = readModelIdField.getLongValue();
            Long longModelLength = readModelLengthField.getLongValue();
            LOG.info("At {}: Model id={} --> {} registers", (Object)nextModelAddress, (Object)longModelId, (Object)longModelLength);
            if (longModelId == null || longModelId < -1L || longModelId > 65535L) {
                throw new ModbusException("Sunspec: model id " + longModelId + " is invalid", null, 2, null);
            }
            int modelId = Math.toIntExact(longModelId);
            if (longModelLength == null || longModelLength < 0L || longModelLength > 2048L) {
                throw new ModbusException("Sunspec: model " + modelId + ": Invalid Model Length " + longModelLength, null, 2, null);
            }
            modelLength = Math.toIntExact(longModelLength);
            thisModelAddress = nextModelAddress;
            nextModelAddress = nextModelAddress.increment(2 + modelLength);
            if (modelId == -1 || modelId == 65535 || modelId == 0 || modelLength == 0) break;
            models.add(new DeviceSunSpecModel(thisModelAddress, modelId, modelLength));
        }
        models.add(new DeviceSunSpecModel(thisModelAddress, 65535, modelLength));
        return models;
    }

    @NotNull
    public final Pair<Address, SchemaDevice> findSunSpecDevice(@NotNull ModbusDevice modbusDevice) throws ModbusException {
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        Address sunSpecStartAddress = null;
        SchemaDevice schemaDevice = null;
        Integer[] integerArray = ConstantsKt.getSUNSPEC_STANDARD_START_PHYSICAL_ADDRESS();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int actualStartAddress = integerArray[i];
            sunSpecStartAddress = Address.Companion.of(AddressClass.HOLDING_REGISTER, actualStartAddress);
            LOG.info("Looking for SunSpec header at {}", (Object)sunSpecStartAddress);
            schemaDevice = SchemaDevice.Companion.builder().description("A SunSpec device with base " + sunSpecStartAddress).build();
            SchemaDevice.connect$default((SchemaDevice)schemaDevice, (ModbusDevice)modbusDevice, (int)0, (int)2, null);
            Field sunSHeaderField = Utils.INSTANCE.addSunSHeaderBlock(schemaDevice, sunSpecStartAddress);
            SchemaDevice.updateAll$default((SchemaDevice)schemaDevice, (long)0L, (int)1, null);
            String sunSHeaderFieldValue = sunSHeaderField.getStringValue();
            if (Intrinsics.areEqual((Object)"SunS", (Object)sunSHeaderFieldValue)) {
                LOG.info("Found the SunSpec header at {}", (Object)sunSpecStartAddress);
                break;
            }
            LOG.info("There is no SunSpec header at {}", (Object)sunSpecStartAddress);
            sunSpecStartAddress = null;
            schemaDevice = null;
        }
        if (sunSpecStartAddress == null) {
            String string = Arrays.toString((Object[])ConstantsKt.getSUNSPEC_STANDARD_START_PHYSICAL_ADDRESS());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new ModbusException("Unable to find the needed SunS header at any of " + string, null, 2, null);
        }
        return new Pair(sunSpecStartAddress, schemaDevice);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0010"}, d2={"Lnl/basjes/sunspec/device/SunSpecDeviceModelFinder$DeviceSunSpecModel;", "", "address", "Lnl/basjes/modbus/device/api/Address;", "id", "", "registers", "<init>", "(Lnl/basjes/modbus/device/api/Address;II)V", "getAddress", "()Lnl/basjes/modbus/device/api/Address;", "getId", "()I", "getRegisters", "toString", "", "sunspec-device"})
    public static final class DeviceSunSpecModel {
        @NotNull
        private final Address address;
        private final int id;
        private final int registers;

        public DeviceSunSpecModel(@NotNull Address address, int id, int registers) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            this.address = address;
            this.id = id;
            this.registers = registers;
        }

        @NotNull
        public final Address getAddress() {
            return this.address;
        }

        public final int getId() {
            return this.id;
        }

        public final int getRegisters() {
            return this.registers;
        }

        @NotNull
        public String toString() {
            return "DeviceSunSpecModel(@" + this.address + ", id=" + this.id + ", registers=" + this.registers + "}";
        }
    }
}

