/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.sunspec.model.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nl.basjes.sunspec.model.entities.Group;
import nl.basjes.sunspec.model.entities.Point;
import nl.basjes.sunspec.model.entities.SunSpecModel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lnl/basjes/sunspec/model/entities/Utils;", "", "<init>", "()V", "fixProblemsInStandardSunSpec", "", "model", "Lnl/basjes/sunspec/model/entities/SunSpecModel;", "group", "Lnl/basjes/sunspec/model/entities/Group;", "fixUnclearLabelsInStandardSunSpec", "markPointAsTimestamp", "point", "Lnl/basjes/sunspec/model/entities/Point;", "markTimestampFields", "sunspec-model"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nnl/basjes/sunspec/model/entities/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1#2:110\n108#3:111\n80#3,22:112\n1374#4:134\n1460#4,5:135\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nnl/basjes/sunspec/model/entities/Utils\n*L\n60#1:111\n60#1:112,22\n102#1:134\n102#1:135,5\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final void fixProblemsInStandardSunSpec(@NotNull SunSpecModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.fixProblemsInStandardSunSpec(model.getGroup());
        this.fixUnclearLabelsInStandardSunSpec(model);
        this.markTimestampFields(model);
    }

    /*
     * WARNING - void declaration
     */
    private final void fixProblemsInStandardSunSpec(Group group) {
        for (Group subGroup : group.getGroups()) {
            this.fixProblemsInStandardSunSpec(subGroup);
        }
        for (Point point : group.getPoints()) {
            void $this$trim$iv;
            CharSequence charSequence;
            Object description;
            String label = point.getLabel();
            if (label != null) {
                point.setLabel(StringsKt.replace$default((String)label, (String)"Sting", (String)"String", (boolean)false, (int)4, null));
            }
            if ((description = point.getDescription()) == null) continue;
            CharSequence charSequence2 = (CharSequence)description;
            Regex regex = new Regex("^Bit Mask indicating (.*)$");
            String string = "$1 (Bitmask)";
            if ((charSequence2 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)regex.replace(charSequence2, string), (String)"Bit flags.", (String)"", (boolean)false, (int)4, null), (String)"Bitfield value.", (String)"", (boolean)false, (int)4, null), (String)"Bitmask value.", (String)"", (boolean)false, (int)4, null), (String)"Bitmask values.", (String)"", (boolean)false, (int)4, null), (String)"Bitmask value", (String)"", (boolean)false, (int)4, null), (String)"Bitmask values", (String)"", (boolean)false, (int)4, null), (String)"Enumerated value indicates if curve is ", (String)"Curve is ", (boolean)false, (int)4, null), (String)"Enumerated value.", (String)"", (boolean)false, (int)4, null), (String)"Enumerated valued.", (String)"", (boolean)false, (int)4, null), (String)"Enumerated value", (String)"", (boolean)false, (int)4, null)).length() > 0) {
                void it22;
                char c = ((String)charSequence2).charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                String string2 = String.valueOf((char)it22);
                Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type java.lang.String");
                String string3 = string2.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
                CharSequence it22 = charSequence2;
                n = 1;
                String string4 = ((String)it22).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                charSequence = stringBuilder2.append(string4).toString();
            } else {
                charSequence = charSequence2;
            }
            charSequence2 = charSequence;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            description = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            description = (String)description + "...";
            charSequence2 = (CharSequence)description;
            regex = new Regex("\\.+$");
            string = ".";
            charSequence2 = regex.replace(charSequence2, string);
            regex = new Regex(" +");
            string = " ";
            description = regex.replace(charSequence2, string);
            point.setDescription((String)description);
        }
    }

    private final void fixUnclearLabelsInStandardSunSpec(SunSpecModel model) {
        block14: {
            if (model.getId() != 702) break block14;
            for (Point point : model.getGroup().getPoints()) {
                switch (point.getName()) {
                    case "IntIslandCatRtg": {
                        point.setLabel("Intentional Island Categories Rating");
                        break;
                    }
                    case "WUndExtRtgPF": {
                        point.setLabel("Specified Under-Excited Rating Power Factor");
                        break;
                    }
                    case "WOvrExtRtgPF": {
                        point.setLabel("Specified Over-Excited Rating Power Factor");
                    }
                }
            }
        }
    }

    private final void markPointAsTimestamp(Point point) {
        if (!(point.getType() == Point.Type.UINT_32)) {
            boolean bl = false;
            String string = "Any type that should be a Timestamp MUST be in the schema as a uint32";
            throw new IllegalArgumentException(string.toString());
        }
        point.setType(Point.Type.TIMESTAMP);
        point.setDescription(point.getDescription() + " Converted to standard UNIX Epoch in Milliseconds.");
    }

    /*
     * Unable to fully structure code
     */
    private final void markTimestampFields(SunSpecModel model) {
        switch (model.getId()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 220: {
                var4_2 = model.getGroup().getPoints();
                for (T var6_12 : var4_2) {
                    it = (Point)var6_12;
                    $i$a$-find-Utils$markTimestampFields$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Ts")) continue;
                    v0 = var6_12;
                    ** GOTO lbl11
                }
                v0 = null;
lbl11:
                // 2 sources

                var2_23 = v0;
                if (var2_23 == null) break;
                it = var2_23;
                $i$a$-let-Utils$markTimestampFields$2 = false;
                Utils.INSTANCE.markPointAsTimestamp(it);
                break;
            }
            case 122: 
            case 501: 
            case 502: {
                it = model.getGroup().getPoints();
                $i$a$-let-Utils$markTimestampFields$2 = it.iterator();
                while ($i$a$-let-Utils$markTimestampFields$2.hasNext()) {
                    var6_13 = $i$a$-let-Utils$markTimestampFields$2.next();
                    it = (Point)var6_13;
                    $i$a$-find-Utils$markTimestampFields$3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Tms")) continue;
                    v1 = var6_13;
                    ** GOTO lbl28
                }
                v1 = null;
lbl28:
                // 2 sources

                var2_24 = v1;
                if (var2_24 == null) break;
                it = var2_24;
                $i$a$-let-Utils$markTimestampFields$4 = false;
                Utils.INSTANCE.markPointAsTimestamp((Point)it);
                break;
            }
            case 133: {
                $this$flatMap$iv = model.getGroup().getGroups();
                $i$f$flatMap = false;
                $i$a$-let-Utils$markTimestampFields$4 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                $i$a$-find-Utils$markTimestampFields$3 = $this$flatMapTo$iv$iv.iterator();
                while ($i$a$-find-Utils$markTimestampFields$3.hasNext()) {
                    element$iv$iv = $i$a$-find-Utils$markTimestampFields$3.next();
                    group = (Group)element$iv$iv;
                    $i$a$-flatMap-Utils$markTimestampFields$5 = false;
                    list$iv$iv = group.getPoints();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $i$f$flatMap = (List)destination$iv$iv;
                for (T var6_14 : $i$f$flatMap) {
                    it = (Point)var6_14;
                    $i$a$-find-Utils$markTimestampFields$6 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"StrTms")) continue;
                    v2 = var6_14;
                    ** GOTO lbl58
                }
                v2 = null;
lbl58:
                // 2 sources

                var2_25 = v2;
                if (var2_25 == null) break;
                it = var2_25;
                $i$a$-let-Utils$markTimestampFields$7 = false;
                Utils.INSTANCE.markPointAsTimestamp(it);
                break;
            }
        }
    }
}

