/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.sunspec.model.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nl.basjes.sunspec.model.entities.Group;
import nl.basjes.sunspec.model.entities.Point;
import nl.basjes.sunspec.model.entities.SunSpecModel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\n\u001a\u00020\u0005*\u00020\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0002J\f\u0010\u000e\u001a\u00020\u0005*\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R%\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00180\u0017\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR%\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00180\u0017\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u001d\u0010\u001aR%\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00180\u0017\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u001f\u0010\u001aR)\u0010 \u001a\u001a\u0012\u0004\u0012\u00020!\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0011\u00a8\u0006#"}, d2={"Lnl/basjes/sunspec/model/entities/FixesAndImprovements;", "", "<init>", "()V", "fixProblemsInStandardSunSpec", "", "model", "Lnl/basjes/sunspec/model/entities/SunSpecModel;", "group", "Lnl/basjes/sunspec/model/entities/Group;", "fixUnclearLabelsInStandardSunSpec", "mapping", "", "", "fixUnclearGroupNames", "groupNameToName", "getGroupNameToName", "()Ljava/util/Map;", "markPointAsTimestamp", "point", "Lnl/basjes/sunspec/model/entities/Point;", "markTimestampFields", "digitalSignature", "", "Lkotlin/Pair;", "getDigitalSignature", "()[Lkotlin/Pair;", "[Lkotlin/Pair;", "certificate", "getCertificate", "powerRelatedPoints", "getPowerRelatedPoints", "pointNameToLabel", "", "getPointNameToLabel", "sunspec-model"})
@SourceDebugExtension(value={"SMAP\nFixesAndImprovements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixesAndImprovements.kt\nnl/basjes/sunspec/model/entities/FixesAndImprovements\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,491:1\n1#2:492\n106#3:493\n78#3,22:494\n1869#4,2:516\n1869#4,2:518\n1869#4,2:520\n1374#4:522\n1460#4,5:523\n1563#4:528\n1634#4,3:529\n1563#4:536\n1634#4,3:537\n1563#4:544\n1634#4,3:545\n1563#4:552\n1634#4,3:553\n1563#4:560\n1634#4,3:561\n1563#4:568\n1634#4,3:569\n37#5:532\n36#5,3:533\n37#5:540\n36#5,3:541\n37#5:548\n36#5,3:549\n37#5:556\n36#5,3:557\n37#5:564\n36#5,3:565\n37#5:572\n36#5,3:573\n*S KotlinDebug\n*F\n+ 1 FixesAndImprovements.kt\nnl/basjes/sunspec/model/entities/FixesAndImprovements\n*L\n60#1:493\n60#1:494,22\n85#1:516,2\n88#1:518,2\n93#1:520,2\n120#1:522\n120#1:523,5\n226#1:528\n226#1:529,3\n232#1:536\n232#1:537,3\n238#1:544\n238#1:545,3\n239#1:552\n239#1:553,3\n246#1:560\n246#1:561,3\n260#1:568\n260#1:569,3\n226#1:532\n226#1:533,3\n232#1:540\n232#1:541,3\n238#1:548\n238#1:549,3\n239#1:556\n239#1:557,3\n246#1:564\n246#1:565,3\n260#1:572\n260#1:573,3\n*E\n"})
public final class FixesAndImprovements {
    @NotNull
    public static final FixesAndImprovements INSTANCE;
    @NotNull
    private static final Map<String, String> groupNameToName;
    @NotNull
    private static final Pair<String, String>[] digitalSignature;
    @NotNull
    private static final Pair<String, String>[] certificate;
    @NotNull
    private static final Pair<String, String>[] powerRelatedPoints;
    @NotNull
    private static final Map<Integer, Map<String, String>> pointNameToLabel;

    private FixesAndImprovements() {
    }

    public final void fixProblemsInStandardSunSpec(@NotNull SunSpecModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.fixProblemsInStandardSunSpec(model.getGroup());
        this.fixUnclearLabelsInStandardSunSpec(model);
        this.markTimestampFields(model);
    }

    /*
     * WARNING - void declaration
     */
    private final void fixProblemsInStandardSunSpec(Group group) {
        for (Group subGroup : group.getGroups()) {
            this.fixProblemsInStandardSunSpec(subGroup);
        }
        for (Point point : group.getPoints()) {
            Object description;
            String label = point.getLabel();
            if (label != null) {
                point.setLabel(StringsKt.replace$default((String)label, (String)"Sting", (String)"String", (boolean)false, (int)4, null));
            }
            if ((description = point.getDescription()) != null) {
                void $this$trim$iv;
                CharSequence charSequence;
                CharSequence charSequence2 = (CharSequence)description;
                Regex regex = new Regex("^Bit Mask indicating (.*)$");
                String string = "$1 (Bitmask)";
                if ((charSequence2 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)regex.replace(charSequence2, string), (String)"Bit flags.", (String)"", (boolean)false, (int)4, null), (String)"Bitfield value.", (String)"", (boolean)false, (int)4, null), (String)"Bitmask value.", (String)"", (boolean)false, (int)4, null), (String)"Bitmask values.", (String)"", (boolean)false, (int)4, null), (String)"Bitmask value", (String)"", (boolean)false, (int)4, null), (String)"Bitmask values", (String)"", (boolean)false, (int)4, null), (String)"Enumerated value indicates if curve is ", (String)"Curve is ", (boolean)false, (int)4, null), (String)"Enumerated value.", (String)"", (boolean)false, (int)4, null), (String)"Enumerated valued.", (String)"", (boolean)false, (int)4, null), (String)"Enumerated value", (String)"", (boolean)false, (int)4, null)).length() > 0) {
                    void it22;
                    char c = ((String)charSequence2).charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = 0;
                    String string2 = String.valueOf((char)it22);
                    Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type java.lang.String");
                    String string3 = string2.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
                    CharSequence it22 = charSequence2;
                    n = 1;
                    String string4 = ((String)it22).substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    charSequence = stringBuilder2.append(string4).toString();
                } else {
                    charSequence = charSequence2;
                }
                charSequence2 = charSequence;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                description = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                description = (String)description + "...";
                charSequence2 = (CharSequence)description;
                regex = new Regex("\\.+$");
                string = ".";
                charSequence2 = regex.replace(charSequence2, string);
                regex = new Regex(" +");
                string = " ";
                description = regex.replace(charSequence2, string);
                point.setDescription((String)description);
            }
            point.setUnits(Intrinsics.areEqual((Object)point.getUnits(), (Object)"C") ? "\u00b0C" : point.getUnits());
        }
    }

    private final void fixUnclearLabelsInStandardSunSpec(SunSpecModel model) {
        this.fixUnclearGroupNames(model.getGroup());
        Map<String, String> map = pointNameToLabel.get(model.getId());
        if (map == null) {
            return;
        }
        Map<String, String> mapping = map;
        this.fixUnclearLabelsInStandardSunSpec(model.getGroup(), mapping);
    }

    private final void fixUnclearLabelsInStandardSunSpec(Group $this$fixUnclearLabelsInStandardSunSpec, Map<String, String> mapping) {
        String string = groupNameToName.get($this$fixUnclearLabelsInStandardSunSpec.getName());
        if (string == null) {
            string = $this$fixUnclearLabelsInStandardSunSpec.getName();
        }
        $this$fixUnclearLabelsInStandardSunSpec.setName(string);
        Iterable $this$forEach$iv = $this$fixUnclearLabelsInStandardSunSpec.getPoints();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Point point = (Point)element$iv;
            boolean bl = false;
            String string2 = mapping.get(point.getName());
            if (string2 == null) continue;
            point.setLabel(string2);
        }
        $this$forEach$iv = $this$fixUnclearLabelsInStandardSunSpec.getGroups();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Group it = (Group)element$iv;
            boolean bl = false;
            INSTANCE.fixUnclearLabelsInStandardSunSpec(it, mapping);
        }
    }

    private final void fixUnclearGroupNames(Group $this$fixUnclearGroupNames) {
        String string = groupNameToName.get($this$fixUnclearGroupNames.getName());
        if (string == null) {
            string = $this$fixUnclearGroupNames.getName();
        }
        $this$fixUnclearGroupNames.setName(string);
        Iterable $this$forEach$iv = $this$fixUnclearGroupNames.getGroups();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Group it = (Group)element$iv;
            boolean bl = false;
            INSTANCE.fixUnclearGroupNames(it);
        }
    }

    @NotNull
    public final Map<String, String> getGroupNameToName() {
        return groupNameToName;
    }

    private final void markPointAsTimestamp(Point point) {
        if (!(point.getType() == Point.Type.UINT_32)) {
            boolean bl = false;
            String string = "Any type that should be a Timestamp MUST be in the schema as a uint32";
            throw new IllegalArgumentException(string.toString());
        }
        point.setType(Point.Type.TIMESTAMP);
    }

    /*
     * Unable to fully structure code
     */
    private final void markTimestampFields(SunSpecModel model) {
        switch (model.getId()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 220: {
                var4_2 = model.getGroup().getPoints();
                for (T var6_12 : var4_2) {
                    it = (Point)var6_12;
                    $i$a$-find-FixesAndImprovements$markTimestampFields$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Ts")) continue;
                    v0 = var6_12;
                    ** GOTO lbl11
                }
                v0 = null;
lbl11:
                // 2 sources

                var2_23 = v0;
                if (var2_23 == null) break;
                it = var2_23;
                $i$a$-let-FixesAndImprovements$markTimestampFields$2 = false;
                FixesAndImprovements.INSTANCE.markPointAsTimestamp(it);
                break;
            }
            case 122: 
            case 501: 
            case 502: {
                it = model.getGroup().getPoints();
                $i$a$-let-FixesAndImprovements$markTimestampFields$2 = it.iterator();
                while ($i$a$-let-FixesAndImprovements$markTimestampFields$2.hasNext()) {
                    var6_13 = $i$a$-let-FixesAndImprovements$markTimestampFields$2.next();
                    it = (Point)var6_13;
                    $i$a$-find-FixesAndImprovements$markTimestampFields$3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Tms")) continue;
                    v1 = var6_13;
                    ** GOTO lbl28
                }
                v1 = null;
lbl28:
                // 2 sources

                var2_24 = v1;
                if (var2_24 == null) break;
                it = var2_24;
                $i$a$-let-FixesAndImprovements$markTimestampFields$4 = false;
                FixesAndImprovements.INSTANCE.markPointAsTimestamp((Point)it);
                break;
            }
            case 133: {
                $this$flatMap$iv = model.getGroup().getGroups();
                $i$f$flatMap = false;
                $i$a$-let-FixesAndImprovements$markTimestampFields$4 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                $i$a$-find-FixesAndImprovements$markTimestampFields$3 = $this$flatMapTo$iv$iv.iterator();
                while ($i$a$-find-FixesAndImprovements$markTimestampFields$3.hasNext()) {
                    element$iv$iv = $i$a$-find-FixesAndImprovements$markTimestampFields$3.next();
                    group = (Group)element$iv$iv;
                    $i$a$-flatMap-FixesAndImprovements$markTimestampFields$5 = false;
                    list$iv$iv = group.getPoints();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $i$f$flatMap = (List)destination$iv$iv;
                for (T var6_14 : $i$f$flatMap) {
                    it = (Point)var6_14;
                    $i$a$-find-FixesAndImprovements$markTimestampFields$6 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"StrTms")) continue;
                    v2 = var6_14;
                    ** GOTO lbl58
                }
                v2 = null;
lbl58:
                // 2 sources

                var2_25 = v2;
                if (var2_25 == null) break;
                it = var2_25;
                $i$a$-let-FixesAndImprovements$markTimestampFields$7 = false;
                FixesAndImprovements.INSTANCE.markPointAsTimestamp(it);
                break;
            }
        }
    }

    @NotNull
    public final Pair<String, String>[] getDigitalSignature() {
        return digitalSignature;
    }

    @NotNull
    public final Pair<String, String>[] getCertificate() {
        return certificate;
    }

    @NotNull
    public final Pair<String, String>[] getPowerRelatedPoints() {
        return powerRelatedPoints;
    }

    @NotNull
    public final Map<Integer, Map<String, String>> getPointNameToLabel() {
        return pointNameToLabel;
    }

    /*
     * WARNING - void declaration
     */
    static {
        int it;
        Collection<Pair> collection;
        int item$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        INSTANCE = new FixesAndImprovements();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Ctl", (Object)"Control"), TuplesKt.to((Object)"Crv", (Object)"Curve"), TuplesKt.to((Object)"Pt", (Object)"Point"), TuplesKt.to((Object)"Prt", (Object)"Port")};
        groupNameToName = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"N", (Object)"Number of digital signature registers"), TuplesKt.to((Object)"DS", (Object)"Digital Signature")};
        digitalSignature = pairArray;
        pairArray = new Pair[]{TuplesKt.to((Object)"N", (Object)"Number of certificate registers"), TuplesKt.to((Object)"Cert", (Object)"Certificate")};
        certificate = pairArray;
        pairArray = new Pair[]{TuplesKt.to((Object)"A", (Object)"AC Current"), TuplesKt.to((Object)"AphA", (Object)"AC Current Phase A"), TuplesKt.to((Object)"AphB", (Object)"AC Current Phase B"), TuplesKt.to((Object)"AphC", (Object)"AC Current Phase C"), TuplesKt.to((Object)"PPV", (Object)"AC Voltage LL"), TuplesKt.to((Object)"PPVphAB", (Object)"AC Voltage Phase AB"), TuplesKt.to((Object)"PPVphBC", (Object)"AC Voltage Phase BC"), TuplesKt.to((Object)"PPVphCA", (Object)"AC Voltage Phase CA"), TuplesKt.to((Object)"PhV", (Object)"AC Voltage"), TuplesKt.to((Object)"PhVphA", (Object)"AC Voltage Phase AN"), TuplesKt.to((Object)"PhVphB", (Object)"AC Voltage Phase BN"), TuplesKt.to((Object)"PhVphC", (Object)"AC Voltage Phase CN"), TuplesKt.to((Object)"W", (Object)"AC Power"), TuplesKt.to((Object)"WphA", (Object)"AC Power Phase A"), TuplesKt.to((Object)"WphB", (Object)"AC Power Phase B"), TuplesKt.to((Object)"WphC", (Object)"AC Power Phase C"), TuplesKt.to((Object)"Hz", (Object)"AC Line Frequency"), TuplesKt.to((Object)"VA", (Object)"AC Apparent Power"), TuplesKt.to((Object)"VAphA", (Object)"AC Apparent Power Phase A"), TuplesKt.to((Object)"VAphB", (Object)"AC Apparent Power Phase B"), TuplesKt.to((Object)"VAphC", (Object)"AC Apparent Power Phase C"), TuplesKt.to((Object)"VAr", (Object)"AC Reactive Power"), TuplesKt.to((Object)"VArphA", (Object)"AC Reactive Power Phase A"), TuplesKt.to((Object)"VArphB", (Object)"AC Reactive Power Phase B"), TuplesKt.to((Object)"VArphC", (Object)"AC Reactive Power Phase C"), TuplesKt.to((Object)"VAR", (Object)"AC Reactive Power"), TuplesKt.to((Object)"VARphA", (Object)"AC Reactive Power Phase A"), TuplesKt.to((Object)"VARphB", (Object)"AC Reactive Power Phase B"), TuplesKt.to((Object)"VARphC", (Object)"AC Reactive Power Phase C"), TuplesKt.to((Object)"PF", (Object)"AC Power Factor"), TuplesKt.to((Object)"PFphA", (Object)"AC Power Factor Phase A"), TuplesKt.to((Object)"PFphB", (Object)"AC Power Factor Phase B"), TuplesKt.to((Object)"PFphC", (Object)"AC Power Factor Phase C"), TuplesKt.to((Object)"Wh", (Object)"AC Energy"), TuplesKt.to((Object)"WH", (Object)"AC Energy"), TuplesKt.to((Object)"DCA", (Object)"DC Current"), TuplesKt.to((Object)"DCV", (Object)"DC Voltage"), TuplesKt.to((Object)"DCW", (Object)"DC Power"), TuplesKt.to((Object)"TotWhExp", (Object)"Total Real Energy Exported"), TuplesKt.to((Object)"TotWhExpPhA", (Object)"Total Real Energy Exported Phase A"), TuplesKt.to((Object)"TotWhExpPhB", (Object)"Total Real Energy Exported Phase B"), TuplesKt.to((Object)"TotWhExpPhC", (Object)"Total Real Energy Exported Phase C"), TuplesKt.to((Object)"TotWhImp", (Object)"Total Real Energy Imported"), TuplesKt.to((Object)"TotWhImpPhA", (Object)"Total Real Energy Imported Phase A"), TuplesKt.to((Object)"TotWhImpPhB", (Object)"Total Real Energy Imported Phase B"), TuplesKt.to((Object)"TotWhImpPhC", (Object)"Total Real Energy Imported Phase C"), TuplesKt.to((Object)"TotVAhExp", (Object)"Total Apparent Energy Exported"), TuplesKt.to((Object)"TotVAhExpPhA", (Object)"Total Apparent Energy Exported Phase A"), TuplesKt.to((Object)"TotVAhExpPhB", (Object)"Total Apparent Energy Exported Phase B"), TuplesKt.to((Object)"TotVAhExpPhC", (Object)"Total Apparent Energy Exported Phase C"), TuplesKt.to((Object)"TotVAhImp", (Object)"Total Apparent Energy Imported"), TuplesKt.to((Object)"TotVAhImpPhA", (Object)"Total Apparent Energy Imported Phase A"), TuplesKt.to((Object)"TotVAhImpPhB", (Object)"Total Apparent Energy Imported Phase B"), TuplesKt.to((Object)"TotVAhImpPhC", (Object)"Total Apparent Energy Imported Phase C"), TuplesKt.to((Object)"TotVArhImpQ1", (Object)"Total Reactive Energy Imported Q1"), TuplesKt.to((Object)"TotVArhImpQ1PhA", (Object)"Total Reactive Energy Imported Q1 Phase A"), TuplesKt.to((Object)"TotVArhImpQ1PhB", (Object)"Total Reactive Energy Imported Q1 Phase B"), TuplesKt.to((Object)"TotVArhImpQ1PhC", (Object)"Total Reactive Energy Imported Q1 Phase C"), TuplesKt.to((Object)"TotVArhImpQ2", (Object)"Total Reactive Energy Imported Q2"), TuplesKt.to((Object)"TotVArhImpQ2PhA", (Object)"Total Reactive Energy Imported Q2 Phase A"), TuplesKt.to((Object)"TotVArhImpQ2PhB", (Object)"Total Reactive Energy Imported Q2 Phase B"), TuplesKt.to((Object)"TotVArhImpQ2PhC", (Object)"Total Reactive Energy Imported Q2 Phase C"), TuplesKt.to((Object)"TotVArhExpQ3", (Object)"Total Reactive Energy Exported Q3"), TuplesKt.to((Object)"TotVArhExpQ3PhA", (Object)"Total Reactive Energy Exported Q3 Phase A"), TuplesKt.to((Object)"TotVArhExpQ3PhB", (Object)"Total Reactive Energy Exported Q3 Phase B"), TuplesKt.to((Object)"TotVArhExpQ3PhC", (Object)"Total Reactive Energy Exported Q3 Phase C"), TuplesKt.to((Object)"TotVArhExpQ4", (Object)"Total Reactive Energy Exported Q4"), TuplesKt.to((Object)"TotVArhExpQ4PhA", (Object)"Total Reactive Energy Exported Q4 Phase A"), TuplesKt.to((Object)"TotVArhExpQ4PhB", (Object)"Total Reactive Energy Exported Q4 Phase B"), TuplesKt.to((Object)"TotVArhExpQ4PhC", (Object)"Total Reactive Energy Exported Q4 Phase C"), TuplesKt.to((Object)"Evt", (Object)"Events"), TuplesKt.to((Object)"Evt1", (Object)"Event Bitfield 1"), TuplesKt.to((Object)"Evt2", (Object)"Event Bitfield 2")};
        powerRelatedPoints = pairArray;
        pairArray = new Pair[32];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"AID", (Object)"Aggregated model id"), TuplesKt.to((Object)"N", (Object)"Number of aggregated models"), TuplesKt.to((Object)"UN", (Object)"Update Number")};
        pairArray[0] = TuplesKt.to((Object)2, (Object)MapsKt.mapOf((Pair[])pairArray2));
        Integer n = 3;
        pairArray2 = new SpreadBuilder(3);
        pairArray2.add((Object)TuplesKt.to((Object)"X", (Object)"Number of requested registers"));
        pairArray2.addSpread(digitalSignature);
        Iterable iterable = (Iterable)new IntRange(1, 50);
        Pair[] pairArray3 = pairArray2;
        Integer n2 = n;
        int n3 = 1;
        Pair[] pairArray4 = pairArray;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int n4 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)("Off" + it), (Object)("Offset " + it)));
        }
        collection = (List)destination$iv$iv;
        Iterable<Object> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<Pair> thisCollection$iv = $this$toTypedArray$iv;
        pairArray3.addSpread((Object)thisCollection$iv.toArray(new Pair[0]));
        pairArray4[n3] = TuplesKt.to((Object)n2, (Object)MapsKt.mapOf((Pair[])((Pair[])pairArray2.toArray((Object[])new Pair[pairArray2.size()]))));
        Integer n5 = 4;
        pairArray2 = new SpreadBuilder(3);
        pairArray2.add((Object)TuplesKt.to((Object)"X", (Object)"Number of requested registers"));
        pairArray2.addSpread(digitalSignature);
        $this$toTypedArray$iv = (Iterable)new IntRange(1, 50);
        pairArray3 = pairArray2;
        n2 = n5;
        n3 = 2;
        pairArray4 = pairArray;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)("Val" + it), (Object)("Value at Offset " + it)));
        }
        $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        pairArray3.addSpread((Object)thisCollection$iv.toArray(new Pair[0]));
        pairArray4[n3] = TuplesKt.to((Object)n2, (Object)MapsKt.mapOf((Pair[])((Pair[])pairArray2.toArray((Object[])new Pair[pairArray2.size()]))));
        Integer n6 = 5;
        pairArray2 = new SpreadBuilder(4);
        pairArray2.add((Object)TuplesKt.to((Object)"X", (Object)"Number of pairs being written"));
        pairArray2.addSpread(digitalSignature);
        $this$toTypedArray$iv = (Iterable)new IntRange(1, 50);
        pairArray3 = pairArray2;
        n2 = n6;
        n3 = 3;
        pairArray4 = pairArray;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)("Off" + it), (Object)("Offset " + it)));
        }
        $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        pairArray3.addSpread((Object)thisCollection$iv.toArray(new Pair[0]));
        $this$toTypedArray$iv = (Iterable)new IntRange(1, 50);
        pairArray3 = pairArray2;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)("Val" + it), (Object)("Value at Offset " + it)));
        }
        $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        pairArray3.addSpread((Object)thisCollection$iv.toArray(new Pair[0]));
        pairArray4[n3] = TuplesKt.to((Object)n2, (Object)MapsKt.mapOf((Pair[])((Pair[])pairArray2.toArray((Object[])new Pair[pairArray2.size()]))));
        Integer n7 = 6;
        pairArray2 = new SpreadBuilder(5);
        pairArray2.add((Object)TuplesKt.to((Object)"X", (Object)"Number of pairs being written"));
        pairArray2.addSpread(digitalSignature);
        pairArray2.add((Object)TuplesKt.to((Object)"Off", (Object)"Starting Offset"));
        $this$toTypedArray$iv = (Iterable)new IntRange(1, 80);
        pairArray3 = pairArray2;
        n2 = n7;
        n3 = 4;
        pairArray4 = pairArray;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)("Val" + it), (Object)("Value at Offset " + it)));
        }
        $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        pairArray3.addSpread((Object)thisCollection$iv.toArray(new Pair[0]));
        pairArray2.add((Object)TuplesKt.to((Object)"Rsrvd", (Object)"Reserved"));
        pairArray4[n3] = TuplesKt.to((Object)n2, (Object)MapsKt.mapOf((Pair[])((Pair[])pairArray2.toArray((Object[])new Pair[pairArray2.size()]))));
        Integer n8 = 7;
        pairArray2 = new SpreadBuilder(2);
        pairArray2.addSpread(digitalSignature);
        pairArray2.add((Object)TuplesKt.to((Object)"Rsrvd", (Object)"Reserved"));
        pairArray[5] = TuplesKt.to((Object)n8, (Object)MapsKt.mapOf((Pair[])((Pair[])pairArray2.toArray((Object[])new Pair[pairArray2.size()]))));
        pairArray2 = certificate;
        pairArray[6] = TuplesKt.to((Object)8, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = new SpreadBuilder(2);
        $this$toTypedArray$iv = (Iterable)new IntRange(1, 80);
        pairArray3 = pairArray2;
        n2 = 9;
        n3 = 7;
        pairArray4 = pairArray;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)("Frg" + it), (Object)("Fragment word " + it)));
        }
        $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        pairArray3.addSpread((Object)thisCollection$iv.toArray(new Pair[0]));
        pairArray2.addSpread(certificate);
        pairArray4[n3] = TuplesKt.to((Object)n2, (Object)MapsKt.mapOf((Pair[])((Pair[])pairArray2.toArray((Object[])new Pair[pairArray2.size()]))));
        pairArray2 = powerRelatedPoints;
        pairArray[8] = TuplesKt.to((Object)101, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[9] = TuplesKt.to((Object)102, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[10] = TuplesKt.to((Object)103, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[11] = TuplesKt.to((Object)111, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[12] = TuplesKt.to((Object)112, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[13] = TuplesKt.to((Object)113, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"DERTyp", (Object)"DERDeviceType"), TuplesKt.to((Object)"WRtg", (Object)"Continuous power output capability"), TuplesKt.to((Object)"VARtg", (Object)"Continuous Volt-Ampere capability"), TuplesKt.to((Object)"VArRtgQ1", (Object)"Continuous VAR capability in quadrant 1"), TuplesKt.to((Object)"VArRtgQ2", (Object)"Continuous VAR capability in quadrant 2"), TuplesKt.to((Object)"VArRtgQ3", (Object)"Continuous VAR capability in quadrant 3"), TuplesKt.to((Object)"VArRtgQ4", (Object)"Continuous VAR capability in quadrant 4"), TuplesKt.to((Object)"ARtg", (Object)"Maximum RMS AC current level capability"), TuplesKt.to((Object)"PFRtgQ1", (Object)"Minimum power factor capability in quadrant 1"), TuplesKt.to((Object)"PFRtgQ2", (Object)"Minimum power factor capability in quadrant 2"), TuplesKt.to((Object)"PFRtgQ3", (Object)"Minimum power factor capability in quadrant 3"), TuplesKt.to((Object)"PFRtgQ4", (Object)"Minimum power factor capability in quadrant 4"), TuplesKt.to((Object)"WHRtg", (Object)"Nominal energy rating"), TuplesKt.to((Object)"AhrRtg", (Object)"Usable battery capacity"), TuplesKt.to((Object)"MaxChaRte", (Object)"Maximum charging energy transfer rate"), TuplesKt.to((Object)"MaxDisChaRte", (Object)"Maximum discharging energy transfer rate")};
        pairArray[14] = TuplesKt.to((Object)120, (Object)MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"WMax", (Object)"Maximum power output"), TuplesKt.to((Object)"VRef", (Object)"Voltage at the PCC"), TuplesKt.to((Object)"VRefOfs", (Object)"Offset from PCC to inverter"), TuplesKt.to((Object)"VMax", (Object)"Maximum voltage"), TuplesKt.to((Object)"VMin", (Object)"Minimum voltage"), TuplesKt.to((Object)"VAMax", (Object)"Maximum apparent power"), TuplesKt.to((Object)"VArMaxQ1", (Object)"Maximum reactive power in quadrant 1"), TuplesKt.to((Object)"VArMaxQ2", (Object)"Maximum reactive power in quadrant 2"), TuplesKt.to((Object)"VArMaxQ3", (Object)"Maximum reactive power in quadrant 3"), TuplesKt.to((Object)"VArMaxQ4", (Object)"Maximum reactive power in quadrant 4"), TuplesKt.to((Object)"WGra", (Object)"Default ramp rate"), TuplesKt.to((Object)"PFMinQ1", (Object)"Minimum power factor value in quadrant 1"), TuplesKt.to((Object)"PFMinQ2", (Object)"Minimum power factor value in quadrant 2"), TuplesKt.to((Object)"PFMinQ3", (Object)"Minimum power factor value in quadrant 3"), TuplesKt.to((Object)"PFMinQ4", (Object)"Minimum power factor value in quadrant 4"), TuplesKt.to((Object)"VArAct", (Object)"VAR action"), TuplesKt.to((Object)"ClcTotVA", (Object)"Calculation method total apparent power"), TuplesKt.to((Object)"MaxRmpRte", (Object)"Maximum ramp rate"), TuplesKt.to((Object)"ECPNomHz", (Object)"Nominal frequency at ECP"), TuplesKt.to((Object)"ConnPh", (Object)"Connected phase")};
        pairArray[15] = TuplesKt.to((Object)121, (Object)MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"PVConn", (Object)"PV inverter connection status"), TuplesKt.to((Object)"StorConn", (Object)"Storage inverter connection status"), TuplesKt.to((Object)"ECPConn", (Object)"ECP connection status"), TuplesKt.to((Object)"ActWh", (Object)"AC lifetime active energy output"), TuplesKt.to((Object)"ActVAh", (Object)"AC lifetime apparent energy output"), TuplesKt.to((Object)"ActVArhQ1", (Object)"AC lifetime reactive energy output in quadrant 1"), TuplesKt.to((Object)"ActVArhQ2", (Object)"AC lifetime reactive energy output in quadrant 2"), TuplesKt.to((Object)"ActVArhQ3", (Object)"AC lifetime reactive energy output in quadrant 3"), TuplesKt.to((Object)"ActVArhQ4", (Object)"AC lifetime reactive energy output in quadrant 4"), TuplesKt.to((Object)"VArAval", (Object)"Available reactive power"), TuplesKt.to((Object)"WAval", (Object)"Available power"), TuplesKt.to((Object)"StSetLimMsk", (Object)"Limit reached"), TuplesKt.to((Object)"StActCtl", (Object)"Active inverter controls"), TuplesKt.to((Object)"TmSrc", (Object)"Time Source"), TuplesKt.to((Object)"Tms", (Object)"Timestamp"), TuplesKt.to((Object)"RtSt", (Object)"Active ride-through status"), TuplesKt.to((Object)"Ris", (Object)"Isolation resistance")};
        pairArray[16] = TuplesKt.to((Object)122, (Object)MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"Conn_WinTms", (Object)"Connection Time window"), TuplesKt.to((Object)"Conn_RvrtTms", (Object)"Connection Timeout period"), TuplesKt.to((Object)"Conn", (Object)"Connection control"), TuplesKt.to((Object)"WMaxLimPct", (Object)"Power Output Limit Pct"), TuplesKt.to((Object)"WMaxLimPct_WinTms", (Object)"Power Output Limit Pct Change Time window"), TuplesKt.to((Object)"WMaxLimPct_RvrtTms", (Object)"Power Output Limit Pct Change Timeout period"), TuplesKt.to((Object)"WMaxLimPct_RmpTms", (Object)"Power Output Limit Pct Change Ramp Time"), TuplesKt.to((Object)"WMaxLim_Ena", (Object)"Power Output Limit Pct Change Throttle"), TuplesKt.to((Object)"OutPFSet", (Object)"Power Factor"), TuplesKt.to((Object)"OutPFSet_WinTms", (Object)"Power Factor Change Time window"), TuplesKt.to((Object)"OutPFSet_RvrtTms", (Object)"Power Factor Change Timeout period"), TuplesKt.to((Object)"OutPFSet_RmpTms", (Object)"Power Factor Change Ramp Time"), TuplesKt.to((Object)"OutPFSet_Ena", (Object)"Power Factor Change Throttle"), TuplesKt.to((Object)"VArWMaxPct", (Object)"Reactive power in percent of WMax"), TuplesKt.to((Object)"VArMaxPct", (Object)"Reactive power in percent of VArMax"), TuplesKt.to((Object)"VArAvalPct", (Object)"Reactive power in percent of VArAval"), TuplesKt.to((Object)"VArPct_WinTms", (Object)"VAR Limit Change Time window"), TuplesKt.to((Object)"VArPct_RvrtTms", (Object)"VAR Limit Change Timeout period"), TuplesKt.to((Object)"VArPct_RmpTms", (Object)"VAR Limit Change Ramp Time"), TuplesKt.to((Object)"VArPct_Mod", (Object)"VAR percent limit mode"), TuplesKt.to((Object)"VArPct_Ena", (Object)"VAR Percent limit control")};
        pairArray[17] = TuplesKt.to((Object)123, (Object)MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"WChaMax", (Object)"Maximum charge"), TuplesKt.to((Object)"WChaGra", (Object)"Maximum charging rate"), TuplesKt.to((Object)"WDisChaGra", (Object)"Maximum discharge rate"), TuplesKt.to((Object)"StorCtl_Mod", (Object)"Storage control mode"), TuplesKt.to((Object)"VAChaMax", (Object)"Maximum charge VA"), TuplesKt.to((Object)"MinRsvPct", (Object)"Minimum reserve percentage"), TuplesKt.to((Object)"ChaState", (Object)"Charge Percentage"), TuplesKt.to((Object)"StorAval", (Object)"Storage Available"), TuplesKt.to((Object)"InBatV", (Object)"Internal battery voltage"), TuplesKt.to((Object)"ChaSt", (Object)"Charge status"), TuplesKt.to((Object)"OutWRte", (Object)"Discharge rate percentage"), TuplesKt.to((Object)"InWRte", (Object)"Charging rate percentage"), TuplesKt.to((Object)"InOutWRte_WinTms", (Object)"Charge Discharge Rate Change Time window"), TuplesKt.to((Object)"InOutWRte_RvrtTms", (Object)"Charge Discharge Rate Change Timeout period"), TuplesKt.to((Object)"InOutWRte_RmpTms", (Object)"Charge Discharge Rate Change Ramp Time"), TuplesKt.to((Object)"ChaGriSet", (Object)"Charge Grid setting")};
        pairArray[18] = TuplesKt.to((Object)124, (Object)MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"ModEna", (Object)"Enabled"), TuplesKt.to((Object)"SigType", (Object)"Signal Type"), TuplesKt.to((Object)"Sig", (Object)"Signal"), TuplesKt.to((Object)"WinTms", (Object)"Pricing Change Time window"), TuplesKt.to((Object)"RvtTms", (Object)"Pricing Change Timeout period"), TuplesKt.to((Object)"RmpTms", (Object)"Pricing Change Ramp Time")};
        pairArray[19] = TuplesKt.to((Object)125, (Object)MapsKt.mapOf(pairArray2));
        pairArray2 = powerRelatedPoints;
        pairArray[20] = TuplesKt.to((Object)202, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[21] = TuplesKt.to((Object)203, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[22] = TuplesKt.to((Object)204, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[23] = TuplesKt.to((Object)211, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[24] = TuplesKt.to((Object)212, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[25] = TuplesKt.to((Object)213, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        pairArray2 = powerRelatedPoints;
        pairArray[26] = TuplesKt.to((Object)214, (Object)MapsKt.mapOf(Arrays.copyOf(pairArray2, pairArray2.length)));
        Integer n9 = 220;
        pairArray2 = new SpreadBuilder(3);
        pairArray2.addSpread(powerRelatedPoints);
        pairArray2.addSpread(digitalSignature);
        pairArray2.add((Object)TuplesKt.to((Object)"Rsrvd", (Object)"Reserved"));
        pairArray[27] = TuplesKt.to((Object)n9, (Object)MapsKt.mapOf((Pair[])((Pair[])pairArray2.toArray((Object[])new Pair[pairArray2.size()]))));
        pairArray[28] = TuplesKt.to((Object)501, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"Tmp", (Object)"Module Temperature")));
        pairArray[29] = TuplesKt.to((Object)502, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"Tmp", (Object)"Module Temperature")));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"WL1", (Object)"Active power L1"), TuplesKt.to((Object)"VAL1", (Object)"Apparent power L1"), TuplesKt.to((Object)"VarL1", (Object)"Reactive power L1"), TuplesKt.to((Object)"PFL1", (Object)"Power factor L1"), TuplesKt.to((Object)"AL1", (Object)"Current L1"), TuplesKt.to((Object)"VL1L2", (Object)"Phase voltage L1-L2"), TuplesKt.to((Object)"VL1", (Object)"Phase voltage L1-N"), TuplesKt.to((Object)"TotWhInjL1", (Object)"Total active energy injected L1"), TuplesKt.to((Object)"TotWhAbsL1", (Object)"Total active energy absorbed L1"), TuplesKt.to((Object)"TotVarhInjL1", (Object)"Total reactive energy injected L1"), TuplesKt.to((Object)"TotVarhAbsL1", (Object)"Total reactive energy absorbed L1"), TuplesKt.to((Object)"WL2", (Object)"Active power L2"), TuplesKt.to((Object)"VAL2", (Object)"Apparent power L2"), TuplesKt.to((Object)"VarL2", (Object)"Reactive power L2"), TuplesKt.to((Object)"PFL2", (Object)"Power factor L2"), TuplesKt.to((Object)"AL2", (Object)"Current L2"), TuplesKt.to((Object)"VL2L3", (Object)"Phase voltage L2-L3"), TuplesKt.to((Object)"VL2", (Object)"Phase voltage L2-N"), TuplesKt.to((Object)"TotWhInjL2", (Object)"Total active energy injected L2"), TuplesKt.to((Object)"TotWhAbsL2", (Object)"Total active energy absorbed L2"), TuplesKt.to((Object)"TotVarhInjL2", (Object)"Total reactive energy injected L2"), TuplesKt.to((Object)"TotVarhAbsL2", (Object)"Total reactive energy absorbed L2"), TuplesKt.to((Object)"WL3", (Object)"Active power L3"), TuplesKt.to((Object)"VAL3", (Object)"Apparent power L3"), TuplesKt.to((Object)"VarL3", (Object)"Reactive power L3"), TuplesKt.to((Object)"PFL3", (Object)"Power factor L3"), TuplesKt.to((Object)"AL3", (Object)"Current L3"), TuplesKt.to((Object)"VL3L1", (Object)"Phase voltage L3-L1"), TuplesKt.to((Object)"VL3", (Object)"Phase voltage L3-N"), TuplesKt.to((Object)"TotWhInjL3", (Object)"Total active energy injected L3"), TuplesKt.to((Object)"TotWhAbsL3", (Object)"Total active energy absorbed L3"), TuplesKt.to((Object)"TotVarhInjL3", (Object)"Total reactive energy injected L3"), TuplesKt.to((Object)"TotVarhAbsL3", (Object)"Total reactive energy absorbed L3")};
        pairArray[30] = TuplesKt.to((Object)701, (Object)MapsKt.mapOf((Pair[])pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"IntIslandCatRtg", (Object)"Intentional Island Categories Rating"), TuplesKt.to((Object)"WUndExtRtgPF", (Object)"Specified Under-Excited Rating Power Factor"), TuplesKt.to((Object)"WOvrExtRtgPF", (Object)"Specified Over-Excited Rating Power Factor")};
        pairArray[31] = TuplesKt.to((Object)702, (Object)MapsKt.mapOf((Pair[])pairArray2));
        pointNameToLabel = MapsKt.mapOf((Pair[])pairArray);
    }
}

