/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.sunspec.schema.generate;

import com.ghgande.j2mod.modbus.facade.AbstractModbusMaster;
import com.ghgande.j2mod.modbus.facade.ModbusTCPMaster;
import java.util.Arrays;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.device.j2mod.ModbusDeviceJ2Mod;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.YamlLoaderKt;
import nl.basjes.sunspec.device.SunspecDevice;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="SunSpecDump", version={"1.0"}, mixinStandardHelpOptions=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\fR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00028\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\n8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnl/basjes/sunspec/schema/generate/Main;", "Ljava/util/concurrent/Callable;", "", "<init>", "()V", "ipaddress", "", "port", "deviceDescription", "spec", "Lpicocli/CommandLine$Model$CommandSpec;", "call", "()Ljava/lang/Integer;", "Companion", "sunspec-schema-writer"})
public final class Main
implements Callable<Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.Option(names={"-ip", "--ipaddress"}, required=true, description={"The hostname/IP address of the modbus device"})
    @Nullable
    private final String ipaddress;
    @CommandLine.Option(names={"-p", "--port"}, description={"Use modbus port"}, defaultValue="502", showDefaultValue=CommandLine.Help.Visibility.ON_DEMAND)
    private final int port;
    @CommandLine.Option(names={"-desc", "--description"}, description={"The description of this device in the generated Schema file"}, defaultValue="A SunSpec Device", showDefaultValue=CommandLine.Help.Visibility.ON_DEMAND)
    @Nullable
    private final String deviceDescription;
    @CommandLine.Spec
    @Nullable
    private final CommandLine.Model.CommandSpec spec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Integer call() throws Exception {
        AutoCloseable autoCloseable = (AutoCloseable)Companion.getModbusDevice(this.ipaddress, this.port);
        Throwable throwable = null;
        try {
            ModbusDevice modbusDevice = (ModbusDevice)autoCloseable;
            boolean bl = false;
            String schema = Companion.getSchema(modbusDevice, this.deviceDescription);
            System.out.println((Object)"#-------------- BEGIN GENERATED CODE SNIPPET --------------");
            System.out.println((Object)schema);
            System.out.println((Object)"#-------------- END GENERATED CODE SNIPPET --------------");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return 0;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\n\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\b\u00a8\u0006\u0012"}, d2={"Lnl/basjes/sunspec/schema/generate/Main$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "getSchema", "host", "port", "", "description", "getModbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "modbusDevice", "sunspec-schema-writer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            System.exit(new CommandLine((Object)new Main()).execute(Arrays.copyOf(args, args.length)));
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }

        @NotNull
        public final String getSchema(@Nullable String host, int port, @Nullable String description) throws Exception {
            return this.getSchema(this.getModbusDevice(host, port), description);
        }

        @NotNull
        public final ModbusDevice getModbusDevice(@Nullable String host, int port) throws Exception {
            AbstractModbusMaster master = (AbstractModbusMaster)new ModbusTCPMaster(host, port);
            master.connect();
            System.out.println((Object)"Connected.");
            return (ModbusDevice)new ModbusDeviceJ2Mod(master, 126);
        }

        @NotNull
        public final String getSchema(@Nullable ModbusDevice modbusDevice, @Nullable String description) throws ModbusException {
            ModbusDevice modbusDevice2 = modbusDevice;
            Intrinsics.checkNotNull((Object)modbusDevice2);
            String string = description;
            Intrinsics.checkNotNull((Object)string);
            SchemaDevice schemaDevice = SunspecDevice.generate$default((ModbusDevice)modbusDevice2, (String)string, (boolean)false, (int)4, null);
            if (schemaDevice == null) {
                throw new ModbusException("Unable to obtain the schema", null, 2, null);
            }
            SchemaDevice schemaDevice2 = schemaDevice;
            return YamlLoaderKt.toYaml((SchemaDevice)schemaDevice2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

