/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.nblib.geotools;

import java.awt.Point;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CoverageTools {
    public GridCoverage2D make() {
        ArrayList<SensorData> sensorData = new ArrayList<SensorData>();
        sensorData.add(new SensorData(1, 2, 3, 4, 5, 51.2114, 3.13154));
        sensorData.add(new SensorData(2, 3, 4, 2, 1, 51.2122, 3.13354));
        sensorData.add(new SensorData(3, 4, 5, 3, 2, 51.2134, 3.13454));
        sensorData.add(new SensorData(4, 5, 6, 4, 4, 51.2164, 3.13564));
        sensorData.add(new SensorData(5, 6, 7, 45, 5, 51.2117, 3.13454));
        sensorData.add(new SensorData(6, 1, 8, 6, 7, 51.2164, 3.13254));
        double minx = ((SensorData)sensorData.get((int)0)).x;
        double maxx = ((SensorData)sensorData.get((int)0)).x;
        double miny = ((SensorData)sensorData.get((int)0)).y;
        double maxy = ((SensorData)sensorData.get((int)0)).y;
        for (SensorData sd : sensorData) {
            minx = minx < sd.x ? minx : sd.x;
            miny = miny < sd.y ? miny : sd.y;
            maxx = maxx > sd.x ? maxx : sd.x;
            maxy = maxy > sd.y ? maxy : sd.y;
        }
        double diffx = maxx - minx;
        double diffy = maxy - miny;
        double ratio = diffy / diffx;
        Double width = Math.ceil(Math.sqrt((double)sensorData.size() / ratio));
        Double height = Math.ceil(Math.sqrt((double)sensorData.size() * ratio));
        int w = width.intValue();
        int h = height.intValue();
        int bands = 5;
        Point location = new Point(0, 0);
        WritableRaster raster = WritableRaster.createBandedRaster(3, w, h, bands, location);
        for (SensorData sd : sensorData) {
            Double x = Math.floor((sd.x - minx) / (diffx / (width - 1.0)));
            Double y = Math.floor((sd.y - miny) / (diffy / (height - 1.0)));
            raster.setSample(x.intValue(), y.intValue(), 0, sd.b1);
            raster.setSample(x.intValue(), y.intValue(), 1, sd.b2);
            raster.setSample(x.intValue(), y.intValue(), 2, sd.b3);
            raster.setSample(x.intValue(), y.intValue(), 3, sd.b4);
            raster.setSample(x.intValue(), y.intValue(), 4, sd.b5);
        }
        ReferencedEnvelope boundingBox = new ReferencedEnvelope(minx, maxx, miny, maxy, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverageFactory factory = new GridCoverageFactory();
        GridCoverage2D coverage2D = factory.create((CharSequence)"name", raster, (Envelope)boundingBox);
        return coverage2D;
    }

    private class SensorData {
        private final int b1;
        private final int b2;
        private final int b3;
        private final int b4;
        private final int b5;
        private final double x;
        private final double y;

        public SensorData(int b1, int b2, int b3, int b4, int b5, double x, double y) {
            this.b1 = b1;
            this.b2 = b2;
            this.b3 = b3;
            this.b4 = b4;
            this.b5 = b5;
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SensorData other = (SensorData)obj;
            if (this.b1 != other.b1) {
                return false;
            }
            if (this.b2 != other.b2) {
                return false;
            }
            if (this.b3 != other.b3) {
                return false;
            }
            if (this.b4 != other.b4) {
                return false;
            }
            return this.b5 == other.b5;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + this.b1;
            hash = 37 * hash + this.b2;
            hash = 37 * hash + this.b3;
            hash = 37 * hash + this.b4;
            hash = 37 * hash + this.b5;
            return hash;
        }
    }
}

