/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.nblib.geotools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.bebr.nblib.geotools.UTMZone;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeometryTools {
    private static GeometryFactory geometryFactory;
    private static final double ACREAGE_DEVIDER = 10000.0;
    private static final Logger LOGGER;
    public static final int GEOMETRY_INVALID_CUT_EDGES = 1;
    public static final int GEOMETRY_INVALID_DANGLES = 2;
    public static final int GEOMETRY_INVALID_RING_LINES = 3;

    private static GeometryFactory getGeometryFactory() {
        if (geometryFactory != null) {
            return geometryFactory;
        }
        geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        return geometryFactory;
    }

    public static Geometry wktToGeometry(String wkt) {
        try {
            WKTReader wKTReader = new WKTReader(GeometryTools.getGeometryFactory());
            return wKTReader.read(wkt);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Provided argumment " + wkt + " did not contain a parseable geometry ", ex);
        }
    }

    public static Point getPoint(GeometryFactory geometryFactory, double longitude, double latitude) {
        Coordinate coordinate = new Coordinate(longitude, latitude);
        Point geometry = geometryFactory.createPoint(coordinate);
        return geometry;
    }

    public static Point getPoint(double longitude, double latitude) {
        return GeometryTools.getPoint(GeometryTools.getGeometryFactory(), longitude, latitude);
    }

    public static Double getAcreageInHA(Double acreage) {
        return acreage > 0.0 ? acreage / 10000.0 : acreage;
    }

    @Deprecated
    public static Double getAcreageFromGeometry(Geometry geometry) {
        Geometry transFormed = null;
        Double faultValue = new Double(0.0);
        String netherlandsWKT = "MULTIPOLYGON (((3.10000 51.20000, 3.10000 53.55000, 7.210000 53.55000, 7.21000 50.70000, 3.10000 51.20000)))";
        Geometry netherLands = GeometryTools.wktToGeometry(netherlandsWKT);
        if (netherLands.contains(geometry)) {
            try {
                CoordinateReferenceSystem sourceReference = CRS.decode((String)"CRS:84");
                CoordinateReferenceSystem targetReference = CRS.decode((String)"EPSG:28992");
                CoordinateOperation coFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)GeoTools.getDefaultHints()).createOperation(sourceReference, targetReference);
                transFormed = JTS.transform((Geometry)geometry, (MathTransform)coFactory.getMathTransform());
                return transFormed.getArea();
            }
            catch (MismatchedDimensionException | FactoryException | TransformException ex) {
                return faultValue;
            }
        }
        return faultValue;
    }

    public static Double getAreaInHA(Geometry geometry) {
        double ACREAGE_DIVIDER = 10000.0;
        Double faultValue = new Double(0.0);
        UTMZone uTMZone = UTMZone.fromGPSCoordinates(geometry.getCentroid().getY(), geometry.getCentroid().getX());
        try {
            CoordinateReferenceSystem sourceReference = CRS.decode((String)"CRS:84");
            CoordinateReferenceSystem targetReference = CRS.decode((String)uTMZone.getEPSG());
            CoordinateOperation coFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)GeoTools.getDefaultHints()).createOperation(sourceReference, targetReference);
            Geometry transFormed = JTS.transform((Geometry)geometry, (MathTransform)coFactory.getMathTransform());
            Double calculatedArea = transFormed.getArea();
            calculatedArea = calculatedArea / 10000.0;
            return GeometryTools.getPrecisionDouble(calculatedArea);
        }
        catch (MismatchedDimensionException | FactoryException | TransformException ex) {
            LOGGER.log(Level.SEVERE, "Unable to transform geometry {0} to UTMZone {1} , Exception occurred: {2}", new Object[]{geometry, uTMZone.getEPSG(), ex.getMessage()});
            return faultValue;
        }
    }

    protected static double getPrecisionDouble(Double toTransform) {
        boolean SCALE = false;
        boolean BIGDECIMAL_BASE_POWER_OF_TEN = true;
        int precision = 4;
        double log10 = Math.ceil(Math.log10(toTransform));
        BigDecimal transForm = BigDecimal.valueOf(toTransform);
        BigDecimal factor = BigDecimal.valueOf(1L).scaleByPowerOfTen((int)((double)precision - log10));
        return transForm.multiply(factor).setScale(0, RoundingMode.FLOOR).divide(factor).doubleValue();
    }

    public static Point2D getDestinationPoint(double lat1, double lon1, double brng, double dist) {
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(lon1, lat1);
        calculator.setDirection(brng, dist);
        return calculator.getDestinationGeographicPoint();
    }

    public static double getDistance(double lat1, double lon1, double lat2, double lon2) {
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(lon1, lat1);
        calculator.setDestinationGeographicPoint(lon2, lat2);
        return calculator.getOrthodromicDistance();
    }

    public static double getBearing(double lat1, double lon1, double lat2, double lon2) {
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(lon1, lat1);
        calculator.setDestinationGeographicPoint(lon2, lat2);
        return calculator.getAzimuth();
    }

    static {
        LOGGER = Logger.getLogger("eu.agrosense.client.lib.geotools");
    }
}

