/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nl.bebr.mapviewer.data.GeoPosition;
import nl.bebr.mapviewer.data.RepaintCallback;
import nl.bebr.mapviewer.data.Tile;
import nl.bebr.mapviewer.data.TileFactory;
import nl.bebr.mapviewer.data.TileFactoryInfo;
import nl.bebr.mapviewer.data.cache.spi.CacheManager;
import nl.bebr.mapviewer.data.util.ScaleUtil;

public abstract class AbstractMapViewer<T, U extends Tile<T>> {
    private int zoom = 1;
    private Point2D center = new Point2D.Double(0.0, 0.0);
    private TileFactory<T, U> tileFactory;
    private GeoPosition addressLocation;
    private boolean panEnabled = true;
    private boolean zoomEnabled = true;
    private boolean restrictOutsidePanning = false;
    private boolean horizontalWrapped = true;
    private List<RepaintCallback> repaintCallbacks = new ArrayList<RepaintCallback>();
    private static final int MINIMUM_ZOOM = 1;
    protected long scaleValue;
    protected float pixelToMeter;
    private static final int MAXIMUM_SCALE_WIDTH = 150;

    public TileFactory<T, U> getTileFactory() {
        return this.tileFactory;
    }

    public void setZoom(int zoom) {
        if (zoom == this.zoom) {
            return;
        }
        CacheManager.getInstance().setZoomLevel(zoom);
        TileFactoryInfo info = this.getTileFactory().getInfo();
        if (info != null && (zoom < info.getMinimumZoomLevel() || zoom > info.getMaximumZoomLevel())) {
            return;
        }
        int oldzoom = this.zoom;
        Point2D oldCenter = this.getCenter();
        Dimension oldMapSize = this.getTileFactory().getMapSize(oldzoom);
        this.zoom = zoom;
        this.firePropertyChange("zoom", oldzoom, zoom);
        Dimension mapSize = this.getTileFactory().getMapSize(zoom);
        this.setCenter(new Point2D.Double(oldCenter.getX() * (mapSize.getWidth() / oldMapSize.getWidth()), oldCenter.getY() * (mapSize.getHeight() / oldMapSize.getHeight())));
        this.calculateScale();
        this.repaint();
    }

    public int getZoom() {
        return this.zoom;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public void setCenter(Point2D center) {
        Point2D old = this.getCenter();
        if (this.isRestrictOutsidePanning()) {
            double centerX;
            Insets insets = this.getInsets();
            int viewportHeight = this.getHeight() - insets.top - insets.bottom;
            int viewportWidth = this.getWidth() - insets.left - insets.right;
            Rectangle newVP = this.calculateViewportBounds(center);
            if (newVP.getY() < 0.0) {
                double centerY = viewportHeight / 2;
                center = new Point2D.Double(center.getX(), centerY);
            }
            if (!this.isHorizontalWrapped() && newVP.getX() < 0.0) {
                double centerX2 = viewportWidth / 2;
                center = new Point2D.Double(centerX2, center.getY());
            }
            Dimension mapSize = this.getTileFactory().getMapSize(this.getZoom());
            int mapHeight = (int)mapSize.getHeight() * this.getTileFactory().getTileSize(this.getZoom());
            if (newVP.getY() + newVP.getHeight() > (double)mapHeight) {
                double centerY = mapHeight - viewportHeight / 2;
                center = new Point2D.Double(center.getX(), centerY);
            }
            int mapWidth = (int)mapSize.getWidth() * this.getTileFactory().getTileSize(this.getZoom());
            if (!this.isHorizontalWrapped() && newVP.getX() + newVP.getWidth() > (double)mapWidth) {
                centerX = mapWidth - viewportWidth / 2;
                center = new Point2D.Double(centerX, center.getY());
            }
            if ((double)mapHeight < newVP.getHeight()) {
                double centerY = mapHeight / 2;
                center = new Point2D.Double(center.getX(), centerY);
            }
            if (!this.isHorizontalWrapped() && (double)mapWidth < newVP.getWidth()) {
                centerX = mapWidth / 2;
                center = new Point2D.Double(centerX, center.getY());
            }
        }
        old = new Point(5, 6);
        GeoPosition oldGP = this.getCenterPosition();
        this.center = center;
        this.firePropertyChange("center", old, this.center);
        this.firePropertyChange("centerPosition", oldGP, this.getCenterPosition());
        this.calculateScale();
        this.repaint();
    }

    public Rectangle getViewportBounds() {
        return this.calculateViewportBounds(this.getCenter());
    }

    private Rectangle calculateViewportBounds(Point2D center) {
        Insets insets = this.getInsets();
        int viewportWidth = this.getWidth() - insets.left - insets.right;
        int viewportHeight = this.getHeight() - insets.top - insets.bottom;
        double viewportX = center.getX() - (double)(viewportWidth / 2);
        double viewportY = center.getY() - (double)(viewportHeight / 2);
        return new Rectangle((int)viewportX, (int)viewportY, viewportWidth, viewportHeight);
    }

    public void setCenterPosition(GeoPosition geoPosition) {
        GeoPosition oldVal = this.getCenterPosition();
        this.setCenter(this.getTileFactory().geoToPixel(geoPosition, this.zoom));
        this.repaint();
        GeoPosition newVal = this.getCenterPosition();
        this.firePropertyChange("centerPosition", oldVal, newVal);
    }

    public GeoPosition getCenterPosition() {
        return this.getTileFactory().pixelToGeo(this.getCenter(), this.zoom);
    }

    public void setTileFactory(TileFactory<T, U> factory) {
        this.tileFactory = factory;
        this.setZoom(this.zoom);
        CacheManager.getInstance().setMapTypeFolder(factory.getInfo().getName());
    }

    public GeoPosition getAddressLocation() {
        return this.addressLocation;
    }

    public void setAddressLocation(GeoPosition addressLocation) {
        GeoPosition old = this.getAddressLocation();
        this.addressLocation = addressLocation;
        this.setCenter(this.getTileFactory().geoToPixel(addressLocation, this.getZoom()));
        this.firePropertyChange("addressLocation", old, this.getAddressLocation());
        this.repaint();
    }

    public void recenterToAddressLocation() {
        this.setCenter(this.getTileFactory().geoToPixel(this.getAddressLocation(), this.getZoom()));
        this.repaint();
    }

    public void calculateZoomFrom(Set<GeoPosition> positions) {
        if (positions.size() < 2) {
            return;
        }
        int zoom = this.getZoom();
        Rectangle2D rect = this.generateBoundingRect(positions, zoom);
        int count = 0;
        while (!this.getViewportBounds().contains(rect)) {
            Point2D.Double center = new Point2D.Double(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0);
            GeoPosition px = this.getTileFactory().pixelToGeo(center, zoom);
            this.setCenterPosition(px);
            if (++count > 30 || this.getViewportBounds().contains(rect) || ++zoom > 15) break;
            this.setZoom(zoom);
            rect = this.generateBoundingRect(positions, zoom);
        }
    }

    private Rectangle2D generateBoundingRect(Set<GeoPosition> positions, int zoom) {
        Point2D point1 = this.getTileFactory().geoToPixel(positions.iterator().next(), zoom);
        Rectangle2D.Double rect = new Rectangle2D.Double(point1.getX(), point1.getY(), 0.0, 0.0);
        for (GeoPosition pos : positions) {
            Point2D point = this.getTileFactory().geoToPixel(pos, zoom);
            rect.add(point);
        }
        return rect;
    }

    public boolean isPanEnabled() {
        return this.panEnabled;
    }

    public void setPanEnabled(boolean panEnabled) {
        boolean old = this.isPanEnabled();
        this.panEnabled = panEnabled;
        this.firePropertyChange("panEnabled", old, this.isPanEnabled());
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public void setZoomEnabled(boolean zoomEnabled) {
        boolean old = this.isZoomEnabled();
        this.zoomEnabled = zoomEnabled;
        this.firePropertyChange("zoomEnabled", old, this.isZoomEnabled());
    }

    public boolean isRestrictOutsidePanning() {
        return this.restrictOutsidePanning;
    }

    public void setRestrictOutsidePanning(boolean restrictOutsidePanning) {
        this.restrictOutsidePanning = restrictOutsidePanning;
    }

    public boolean isHorizontalWrapped() {
        return this.horizontalWrapped;
    }

    public void setHorizontalWrapped(boolean horizontalWrapped) {
        this.horizontalWrapped = horizontalWrapped;
    }

    public Point2D convertGeoPositionToPoint(GeoPosition pos) {
        Point2D pt = this.getTileFactory().geoToPixel(pos, this.getZoom());
        Rectangle bounds = this.getViewportBounds();
        return new Point2D.Double(pt.getX() - bounds.getX(), pt.getY() - bounds.getY());
    }

    public GeoPosition convertPointToGeoPosition(Point2D pt) {
        Rectangle bounds = this.getViewportBounds();
        Point2D.Double pt2 = new Point2D.Double(pt.getX() + bounds.getX(), pt.getY() + bounds.getY());
        GeoPosition pos = this.getTileFactory().pixelToGeo(pt2, this.getZoom());
        return pos;
    }

    public int calculateZoom(double x, double y) {
        if (x != 0.0 && y != 0.0) {
            double weightX = (double)this.getWidth() / x;
            double weightY = (double)this.getHeight() / y;
            double scale = Math.min(weightX, weightY);
            if ((scale = Math.log(scale) / Math.log(2.0)) < 0.0) {
                scale = -1.0;
            }
            return this.getZoom() - (int)scale;
        }
        return this.getZoom();
    }

    public void zoomToCoordinates(double startX, double startY, double endX, double endY) {
        int maxHeight;
        double oldCenterX = this.getWidth() / 2;
        double oldCenterY = this.getHeight() / 2;
        double centerX = Math.min(startX, endX) + Math.abs(startX - endX) / 2.0;
        double centerY = Math.min(startY, endY) + Math.abs(startY - endY) / 2.0;
        double x = this.getCenter().getX() + (centerX - oldCenterX);
        double y = this.getCenter().getY() + (centerY - oldCenterY);
        if (y > (double)(maxHeight = (int)(this.getTileFactory().getMapSize(this.getZoom()).getHeight() * (double)this.getTileFactory().getTileSize(this.getZoom())))) {
            y = maxHeight;
        }
        this.setCenter(new Point2D.Double(x, y));
        this.setZoomFromPixelPosition(new Point2D.Double(startX, startY), new Point2D.Double(endX, endY));
    }

    protected abstract void firePropertyChange(String var1, Object var2, Object var3);

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract Insets getInsets();

    protected abstract void repaint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRepaintCallbacks() {
        RepaintCallback[] callbacks = null;
        RepaintCallback[] repaintCallbackArray = this;
        synchronized (this) {
            callbacks = this.repaintCallbacks.toArray(new RepaintCallback[this.repaintCallbacks.size()]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (RepaintCallback callback : callbacks) {
                callback.repaint();
            }
            return;
        }
    }

    public synchronized void addRepaintCallback(RepaintCallback repaintCallback) {
        this.repaintCallbacks.add(repaintCallback);
    }

    public synchronized void removeRepaintCallback(RepaintCallback repaintCallback) {
        this.repaintCallbacks.remove(repaintCallback);
    }

    public void setZoomFromGeoPosition(GeoPosition startPosition, GeoPosition endPosition) {
        this.setZoomFromPixelPosition(this.convertGeoPositionToPoint(startPosition), this.convertGeoPositionToPoint(endPosition));
    }

    private void setZoomFromPixelPosition(Point2D startPoint, Point2D endPoint) {
        int calculatedZoom = this.calculateZoom(Math.abs(startPoint.getX() - endPoint.getX()), Math.abs(startPoint.getY() - endPoint.getY()));
        if (calculatedZoom < 1) {
            calculatedZoom = 1;
        }
        if (calculatedZoom != this.getZoom()) {
            this.setZoom(calculatedZoom);
        } else {
            this.repaint();
        }
    }

    private void calculateScale() {
        Point centerPointOnScreen = new Point(this.getWidth() / 2, this.getHeight() / 2);
        GeoPosition startPoint = this.convertPointToGeoPosition(new Point2D.Double(((Point2D)centerPointOnScreen).getX(), ((Point2D)centerPointOnScreen).getY()));
        GeoPosition endPoint = this.convertPointToGeoPosition(new Point2D.Double(((Point2D)centerPointOnScreen).getX() + 100.0, ((Point2D)centerPointOnScreen).getY()));
        float distance = startPoint.distanceTo(endPoint);
        this.pixelToMeter = 100.0f / distance;
        double unitToMetersRatio = ScaleUtil.getUnitToMetersRatio();
        int zoom2 = this.zoom;
        this.scaleValue = ScaleUtil.getScaleValue(this.zoom);
        double width = (double)(this.pixelToMeter * (float)this.scaleValue) * unitToMetersRatio;
        while (width > 150.0 && zoom2 > 1) {
            this.scaleValue = ScaleUtil.getScaleValue(--zoom2);
            width = (double)(this.pixelToMeter * (float)this.scaleValue) * unitToMetersRatio;
        }
    }

    public long getScaleValue() {
        return this.scaleValue;
    }

    public float getPixelToMeter() {
        return this.pixelToMeter;
    }
}

