/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.bebr.mapviewer.data.Tile;
import nl.bebr.mapviewer.data.TileCache;
import nl.bebr.mapviewer.data.TileFactory;
import nl.bebr.mapviewer.data.TileFactoryInfo;
import nl.bebr.mapviewer.data.cache.OfflineTileRunner;
import nl.bebr.mapviewer.data.util.GeoUtil;

public abstract class AbstractTileFactory<T, U extends Tile<T>>
extends TileFactory<T, U> {
    private static final Logger LOG = Logger.getLogger(AbstractTileFactory.class.getName());
    private static final int POOL_SIZE = 5;
    private ExecutorService service;
    private TileCache<T> cache;
    private Runnable[] tileRunner;

    public AbstractTileFactory(TileFactoryInfo info) {
        super(info);
        this.init();
    }

    private void init() {
        this.cache = this.createTileCache();
        this.tileRunner = new Runnable[5];
        for (int i = 0; i < 5; ++i) {
            this.tileRunner[i] = this.createTileRunner();
            this.getService().submit(this.tileRunner[i]);
        }
    }

    @Override
    public U getTile(int x, int y, int zoom) {
        return this.getTile(x, y, zoom, true);
    }

    private U getTile(int tpx, int tpy, int zoom, boolean eagerLoad) {
        Tile<Object> tile;
        int tileX = tpx;
        int numTilesWide = (int)this.getMapSize(zoom).getWidth();
        if (tileX < 0) {
            tileX = numTilesWide - Math.abs(tileX) % numTilesWide;
        }
        int tileY = tpy;
        String url = this.getInfo().getTileUrl(tileX %= numTilesWide, tileY, zoom);
        if (!this.getTileMap().containsKey(url)) {
            if (!GeoUtil.isValidTile(tileX, tileY, zoom, this.getInfo())) {
                tile = this.createTile(tileX, tileY, zoom, null, this);
            } else {
                tile = this.createTile(tileX, tileY, zoom, url, this);
                this.startLoading(tile);
            }
            this.getTileMap().put(url, tile);
        } else {
            tile = (Tile)this.getTileMap().get(url);
            if (tile.getPriority() == Tile.Priority.Low && eagerLoad && !tile.isLoaded()) {
                this.promote(tile);
            }
        }
        return (U)tile;
    }

    public TileCache<T> getTileCache() {
        return this.cache;
    }

    public void setTileCache(TileCache<T> cache) {
        this.cache = cache;
    }

    protected synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = Executors.newFixedThreadPool(5, new ThreadFactory(){
                private int count = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "tile-pool-" + this.count++);
                    t.setPriority(1);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.service;
    }

    @Override
    protected synchronized void startLoading(U tile) {
        if (((Tile)tile).isLoading()) {
            return;
        }
        ((Tile)tile).setLoading(true);
        try {
            this.getTileQueue().put(tile);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "error during load start", ex);
        }
    }

    protected abstract Runnable createTileRunner();

    public synchronized void promote(U tile) {
        if (this.getTileQueue().contains(tile)) {
            try {
                this.getTileQueue().remove(tile);
                ((Tile)tile).setPriority(Tile.Priority.High);
                this.getTileQueue().put(tile);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "error while promoting", ex);
            }
        }
    }

    public abstract BlockingQueue<U> getTileQueue();

    public abstract TileCache<T> createTileCache();

    public abstract U createTile(int var1, int var2, int var3, String var4, AbstractTileFactory<T, U> var5);

    protected abstract Map<String, U> getTileMap();

    @Override
    public void clearQueueAndStopLoading() {
        for (int i = 0; i < 5; ++i) {
            if (!(this.tileRunner[i] instanceof OfflineTileRunner)) continue;
            ((OfflineTileRunner)this.tileRunner[i]).stop();
        }
        this.getService().shutdown();
        this.getTileQueue().clear();
        this.cache.clear();
    }
}

