/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data;

public class GeoPosition {
    private double latitude;
    private double longitude;
    private static final int MAXITERS = 20;
    private static final double MAJOR_AXIS = 6378137.0;
    private static final double SEMI_MAJOR_AXIS = 6356752.3142;
    private static final double F = 0.0033528106718309896;
    private static final double aSqMinusBSqOverBSq = 0.006739496756586903;

    public GeoPosition(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public GeoPosition(double[] coords) {
        this.latitude = coords[0];
        this.longitude = coords[1];
    }

    public GeoPosition(double latDegrees, double latMinutes, double latSeconds, double lonDegrees, double lonMinutes, double lonSeconds) {
        this(latDegrees + (latMinutes + latSeconds / 60.0) / 60.0, lonDegrees + (lonMinutes + lonSeconds / 60.0) / 60.0);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeoPosition) {
            GeoPosition coord = (GeoPosition)obj;
            return coord.latitude == this.latitude && coord.longitude == this.longitude;
        }
        return false;
    }

    public String toString() {
        return "[" + this.latitude + ", " + this.longitude + "]";
    }

    public float distanceTo(GeoPosition geoPosition) {
        return this.distanceTo(geoPosition.getLatitude(), geoPosition.getLongitude());
    }

    public float distanceTo(double latitudeTo, double longitudeTo) {
        double lat1 = Math.toRadians(this.latitude);
        double lon1 = Math.toRadians(this.longitude);
        double lat2 = Math.toRadians(latitudeTo);
        double lon2 = Math.toRadians(longitudeTo);
        double L = lon2 - lon1;
        double A = 0.0;
        double U1 = Math.atan(0.996647189328169 * Math.tan(lat1));
        double U2 = Math.atan(0.996647189328169 * Math.tan(lat2));
        double cosU1 = Math.cos(U1);
        double cosU2 = Math.cos(U2);
        double sinU1 = Math.sin(U1);
        double sinU2 = Math.sin(U2);
        double cosU1cosU2 = cosU1 * cosU2;
        double sinU1sinU2 = sinU1 * sinU2;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        double lambda = L;
        for (int iter = 0; iter < 20; ++iter) {
            double lambdaOrig = lambda;
            double cosLambda = Math.cos(lambda);
            double sinLambda = Math.sin(lambda);
            double t1 = cosU2 * sinLambda;
            double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
            double sinSqSigma = t1 * t1 + t2 * t2;
            double sinSigma = Math.sqrt(sinSqSigma);
            double cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            double cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            double cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
            double uSquared = cosSqAlpha * 0.006739496756586903;
            A = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
            double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
            double C = 2.0955066698943685E-4 * cosSqAlpha * (4.0 + 0.0033528106718309896 * (4.0 - 3.0 * cosSqAlpha));
            double cos2SMSq = cos2SM * cos2SM;
            deltaSigma = B * sinSigma * (cos2SM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - B / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
            lambda = L + (1.0 - C) * 0.0033528106718309896 * sinAlpha * (sigma + C * sinSigma * (cos2SM + C * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
            double delta = (lambda - lambdaOrig) / lambda;
            if (Math.abs(delta) < 1.0E-12) break;
        }
        float distance = (float)(6356752.3142 * A * (sigma - deltaSigma));
        return distance;
    }
}

