/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import nl.bebr.mapviewer.data.TileFactory;
import nl.bebr.mapviewer.data.util.AbstractBean;

public class Tile<T>
extends AbstractBean {
    private static final Logger LOG = Logger.getLogger(Tile.class.getName());
    public static final String LOADED = "loaded";
    private Priority priority = Priority.High;
    protected TileFactory<T, Tile<T>> tileFactory;
    private boolean isLoading = false;
    private Throwable error;
    private String url;
    private boolean loaded = false;
    private int zoom;
    private int x;
    private int y;
    protected SoftReference<T> image = new SoftReference<Object>(null);
    private PropertyChangeListener uniqueListener = null;

    public Tile(int x, int y, int zoom) {
        this.loaded = false;
        this.zoom = zoom;
        this.x = x;
        this.y = y;
    }

    public Tile(int x, int y, int zoom, String url, TileFactory<T, Tile<T>> tileFactory) {
        this.url = url;
        this.loaded = false;
        this.zoom = zoom;
        this.x = x;
        this.y = y;
        this.tileFactory = tileFactory;
    }

    public Tile(int x, int y, int zoom, String url, Priority priority, TileFactory<T, Tile<T>> tileFactory) {
        this.url = url;
        this.loaded = false;
        this.zoom = zoom;
        this.x = x;
        this.y = y;
        this.priority = priority;
        this.tileFactory = tileFactory;
    }

    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    public synchronized void setLoaded(boolean loaded) {
        boolean old = this.isLoaded();
        this.loaded = loaded;
        this.firePropertyChange(LOADED, old, this.isLoaded());
    }

    public Throwable getUnrecoverableError() {
        return this.error;
    }

    public Throwable getLoadingError() {
        return this.error;
    }

    public T getImage() {
        T img = this.image.get();
        if (img == null) {
            this.setLoaded(false);
            this.tileFactory.startLoading(this);
        }
        return img;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void addUniquePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.uniqueListener != null && this.uniqueListener != listener) {
            this.removePropertyChangeListener(propertyName, this.uniqueListener);
        }
        if (this.uniqueListener != listener) {
            this.uniqueListener = listener;
            this.addPropertyChangeListener(propertyName, this.uniqueListener);
        }
    }

    public void firePropertyChangeOnEDT(final String propertyName, final Object oldValue, final Object newValue) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Tile.this.firePropertyChange(propertyName, oldValue, newValue);
                }
            });
        }
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getURL() {
        return this.url;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    static {
        LOG.setLevel(Level.OFF);
    }

    public static enum Priority {
        High,
        Low;

    }
}

