/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TileCache<T> {
    private static final Logger LOG = Logger.getLogger(TileCache.class.getName());
    private static final long CACHE_SIZE = 0x3200000L;
    private LinkedList<URI> imgmapAccessQueue = new LinkedList();
    private int imagesize = 0;

    public void put(URI uri, T img) {
        this.addToImageCache(uri, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(URI uri) throws IOException {
        Map<URI, T> map = this.getImgMap();
        synchronized (map) {
            if (this.getImgMap().containsKey(uri)) {
                this.imgmapAccessQueue.remove(uri);
                this.imgmapAccessQueue.addLast(uri);
                return this.getImgMap().get(uri);
            }
        }
        return null;
    }

    protected abstract int getImageSizeInBytes(T var1);

    protected abstract Map<URI, T> getImgMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void needMoreMemory() {
        Map<URI, T> map = this.getImgMap();
        synchronized (map) {
            this.getImgMap().clear();
        }
    }

    private void cleanTheCache() {
        for (int retryCounter = 10; (long)this.imagesize > 0x3200000L && retryCounter >= 0; --retryCounter) {
            URI olduri = this.imgmapAccessQueue.removeFirst();
            T oldimg = this.getImgMap().remove(olduri);
            if (oldimg == null) continue;
            this.imagesize -= this.getImageSizeInBytes(oldimg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToImageCache(URI uri, T img) {
        Map<URI, T> map = this.getImgMap();
        synchronized (map) {
            if ((long)this.imagesize > 0x3200000L) {
                LOG.log(Level.FINEST, "Cache needs to be cleared, actual size is: {0} MB", this.imagesize / 0x100000);
                this.cleanTheCache();
            }
            this.getImgMap().put(uri, img);
            this.imagesize += this.getImageSizeInBytes(img);
            this.imgmapAccessQueue.addLast(uri);
        }
    }

    public void clear() {
        this.getImgMap().clear();
        this.imgmapAccessQueue.clear();
        this.imagesize = 0;
    }
}

