/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import nl.bebr.mapviewer.data.GeoPosition;
import nl.bebr.mapviewer.data.Tile;
import nl.bebr.mapviewer.data.TileFactoryInfo;
import nl.bebr.mapviewer.data.util.GeoUtil;

public abstract class TileFactory<T, U extends Tile<T>> {
    private TileFactoryInfo info;

    protected TileFactory(TileFactoryInfo info) {
        this.info = info;
    }

    public int getTileSize(int zoom) {
        return this.getInfo().getTileSize(zoom);
    }

    public Dimension getMapSize(int zoom) {
        return GeoUtil.getMapSize(zoom, this.getInfo());
    }

    public abstract U getTile(int var1, int var2, int var3);

    public GeoPosition pixelToGeo(Point2D pixelCoordinate, int zoom) {
        return GeoUtil.getPosition(pixelCoordinate, zoom, this.getInfo());
    }

    public Point2D geoToPixel(GeoPosition c, int zoomLevel) {
        return GeoUtil.getBitmapCoordinate(c, zoomLevel, this.getInfo());
    }

    public TileFactoryInfo getInfo() {
        return this.info;
    }

    protected abstract void startLoading(U var1);

    public abstract void clearQueueAndStopLoading();
}

