/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data;

import java.awt.geom.Point2D;
import java.net.URI;
import java.net.URL;
import nl.bebr.mapviewer.data.cache.TileCacheInfo;

public class TileFactoryInfo {
    public static final String TILE_EXTENSION = ".png";
    public static final String FILE_NAME_FORMAT = "%dx%d.png";
    private int minimumZoomLevel;
    private int maximumZoomLevel;
    private int totalMapZoom;
    private int tileSize = 256;
    private int[] mapWidthInTilesAtZoom;
    private Point2D[] mapCenterInPixelsAtZoom;
    private double[] longitudeDegreeWidthInPixels;
    private double[] longitudeRadianWidthInPixels;
    protected String baseURL;
    private String xparam;
    private String yparam;
    private String zparam;
    private boolean xr2l = true;
    private boolean yt2b = true;
    private int defaultZoomLevel;
    private String name;
    private URL iconUrl;
    private boolean persistent = true;

    public TileFactoryInfo(int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, String baseURL, String xparam, String yparam, String zparam) {
        this("name not provided", minimumZoomLevel, maximumZoomLevel, totalMapZoom, tileSize, xr2l, yt2b, baseURL, xparam, yparam, zparam);
    }

    public TileFactoryInfo(String name, int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, String baseURL, String xparam, String yparam, String zparam) {
        this.name = name;
        this.minimumZoomLevel = minimumZoomLevel;
        this.maximumZoomLevel = maximumZoomLevel;
        this.totalMapZoom = totalMapZoom;
        this.baseURL = baseURL;
        this.xparam = xparam;
        this.yparam = yparam;
        this.zparam = zparam;
        this.setXr2l(xr2l);
        this.setYt2b(yt2b);
        this.tileSize = tileSize;
        int tilesize = this.getTileSize(0);
        this.longitudeDegreeWidthInPixels = new double[totalMapZoom + 1];
        this.longitudeRadianWidthInPixels = new double[totalMapZoom + 1];
        this.mapCenterInPixelsAtZoom = new Point2D.Double[totalMapZoom + 1];
        this.mapWidthInTilesAtZoom = new int[totalMapZoom + 1];
        for (int z = totalMapZoom; z >= 0; --z) {
            this.longitudeDegreeWidthInPixels[z] = (double)tilesize / 360.0;
            this.longitudeRadianWidthInPixels[z] = (double)tilesize / (Math.PI * 2);
            int t2 = tilesize / 2;
            this.mapCenterInPixelsAtZoom[z] = new Point2D.Double(t2, t2);
            this.mapWidthInTilesAtZoom[z] = tilesize / this.getTileSize(0);
            tilesize *= 2;
        }
    }

    public int getMinimumZoomLevel() {
        return this.minimumZoomLevel;
    }

    public int getMaximumZoomLevel() {
        return this.maximumZoomLevel;
    }

    public int getTotalMapZoom() {
        return this.totalMapZoom;
    }

    public int getMapWidthInTilesAtZoom(int zoom) {
        return this.mapWidthInTilesAtZoom[zoom];
    }

    public Point2D getMapCenterInPixelsAtZoom(int zoom) {
        return this.mapCenterInPixelsAtZoom[zoom];
    }

    public String getTileUrl(int x, int y, int zoom) {
        String ypart = "&" + this.yparam + "=" + y;
        zoom = this.recalculateZoom(zoom);
        if (!this.yt2b) {
            int tilemax = this.getMapWidthInTilesAtZoom(zoom);
            ypart = "&" + this.yparam + "=" + (tilemax / 2 - y - 1);
        }
        String url = this.baseURL + "&" + this.xparam + "=" + x + ypart + "&" + this.zparam + "=" + zoom;
        return url;
    }

    public int getTileSize(int zoom) {
        return this.tileSize;
    }

    public double getLongitudeDegreeWidthInPixels(int zoom) {
        return this.longitudeDegreeWidthInPixels[zoom];
    }

    public double getLongitudeRadianWidthInPixels(int zoom) {
        return this.longitudeRadianWidthInPixels[zoom];
    }

    public boolean isXr2l() {
        return this.xr2l;
    }

    public void setXr2l(boolean xr2l) {
        this.xr2l = xr2l;
    }

    public boolean isYt2b() {
        return this.yt2b;
    }

    public void setYt2b(boolean yt2b) {
        this.yt2b = yt2b;
    }

    public int getDefaultZoomLevel() {
        return this.defaultZoomLevel;
    }

    public void setDefaultZoomLevel(int defaultZoomLevel) {
        this.defaultZoomLevel = defaultZoomLevel;
    }

    public String getName() {
        return this.name;
    }

    public synchronized TileCacheInfo getCacheInfo(URI uri) {
        assert (uri != null);
        String path = uri.getPath();
        if (path != null && path.endsWith(TILE_EXTENSION)) {
            String xyZoom;
            String[] coordinates;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((coordinates = (xyZoom = path.substring(0, path.indexOf(TILE_EXTENSION))).split("/")) != null && coordinates.length == 3) {
                int zoom = Integer.parseInt(coordinates[0]);
                zoom = this.recalculateZoom(zoom);
                int x = Integer.parseInt(coordinates[1]);
                int y = Integer.parseInt(coordinates[2]);
                TileCacheInfo tileCacheInfo = new TileCacheInfo(zoom, x, y);
                tileCacheInfo.setType("OpenStreetMap");
                return tileCacheInfo;
            }
            return null;
        }
        return null;
    }

    public void setIconUrl(URL iconUrl) {
        this.iconUrl = iconUrl;
    }

    public URL getIconUrl() {
        return this.iconUrl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseURL == null ? 0 : this.baseURL.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TileFactoryInfo other = (TileFactoryInfo)obj;
        if (this.baseURL == null ? other.baseURL != null : !this.baseURL.equals(other.baseURL)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    protected int recalculateZoom(int zoom) {
        return zoom;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }
}

