/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import nl.bebr.mapviewer.data.AbstractTileFactory;
import nl.bebr.mapviewer.data.Tile;
import nl.bebr.mapviewer.data.TileCache;

public abstract class TileRunner<T, U extends Tile<T>>
implements Runnable {
    private static final Logger LOG = Logger.getLogger(TileRunner.class.getName());
    private AbstractTileFactory<T, U> tileFactory;
    private TileCache<T> tileCache;

    public TileRunner(AbstractTileFactory<T, U> tileFactory) {
        this.tileFactory = tileFactory;
        this.tileCache = tileFactory.getTileCache();
    }

    protected URI getURI(U tile) throws URISyntaxException {
        if (((Tile)tile).getURL() == null) {
            return null;
        }
        return new URI(((Tile)tile).getURL());
    }

    @Override
    public void run() {
        final Tile tile = (Tile)this.tileFactory.getTileQueue().remove();
        int trys = 3;
        while (!tile.isLoaded() && trys > 0) {
            try {
                Object img = null;
                URI uri = this.getURI(tile);
                img = this.tileCache.get(uri);
                if (img == null) {
                    img = this.loadImage(uri);
                    this.tileCache.put(uri, img);
                    img = this.tileCache.get(uri);
                }
                if (img == null) {
                    LOG.log(Level.INFO, "Failed to load: " + uri);
                    --trys;
                    continue;
                }
                final Object i = img;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        tile.image = new SoftReference<Object>(i);
                        tile.setLoaded(true);
                    }
                });
            }
            catch (OutOfMemoryError memErr) {
                this.tileCache.needMoreMemory();
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Failed to load a tile at url: " + tile.getURL() + ", retrying", e);
                System.err.println("Failed to load a tile at url: " + tile.getURL());
                e.printStackTrace();
                Throwable oldError = tile.getError();
                tile.setError(e);
                tile.firePropertyChangeOnEDT("loadingError", oldError, e);
                if (trys == 0) {
                    tile.firePropertyChangeOnEDT("unrecoverableError", null, e);
                    continue;
                }
                --trys;
            }
        }
        tile.setLoading(false);
    }

    public abstract T loadImage(URI var1) throws MalformedURLException, IOException;
}

