/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.bmng;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import nl.bebr.mapviewer.data.AbstractTileFactory;
import nl.bebr.mapviewer.data.DefaultTileFactory;
import nl.bebr.mapviewer.data.GeoPosition;
import nl.bebr.mapviewer.data.Tile;
import nl.bebr.mapviewer.data.TileCache;
import nl.bebr.mapviewer.data.bmng.SLMapServerInfo;

public class CylindricalProjectionTileFactory<T, U extends Tile<T>>
extends DefaultTileFactory<T, U> {
    public CylindricalProjectionTileFactory() {
        this(new SLMapServerInfo());
    }

    public CylindricalProjectionTileFactory(SLMapServerInfo info) {
        super(info);
    }

    @Override
    public Dimension getMapSize(int zoom) {
        int midpoint = ((SLMapServerInfo)this.getInfo()).getMidpoint();
        if (zoom < midpoint) {
            int w = (int)Math.pow(2.0, midpoint - zoom);
            return new Dimension(w, w / 2);
        }
        return new Dimension(2, 1);
    }

    @Override
    public Point2D geoToPixel(GeoPosition c, int zoom) {
        Dimension mapSizeInTiles = this.getMapSize(zoom);
        double size_in_pixels = mapSizeInTiles.getWidth() * (double)this.getInfo().getTileSize(zoom);
        double ppd = size_in_pixels / 360.0;
        double centerX = (double)this.getTileSize(zoom) * mapSizeInTiles.getWidth() / 2.0;
        double centerY = (double)this.getTileSize(zoom) * mapSizeInTiles.getHeight() / 2.0;
        double x = c.getLongitude() * ppd + centerX;
        double y = -c.getLatitude() * ppd + centerY;
        return new Point2D.Double(x, y);
    }

    @Override
    public GeoPosition pixelToGeo(Point2D pix, int zoom) {
        Dimension mapSizeInTiles = this.getMapSize(zoom);
        double size_in_pixels = mapSizeInTiles.getWidth() * (double)this.getInfo().getTileSize(zoom);
        double ppd = size_in_pixels / 360.0;
        double centerX = (double)this.getTileSize(zoom) * mapSizeInTiles.getWidth() / 2.0;
        double centerY = (double)this.getTileSize(zoom) * mapSizeInTiles.getHeight() / 2.0;
        double lon = (pix.getX() - centerX) / ppd;
        double lat = -(pix.getY() - centerY) / ppd;
        return new GeoPosition(lat, lon);
    }

    @Override
    protected Runnable createTileRunner() {
        return null;
    }

    @Override
    public TileCache<T> createTileCache() {
        return null;
    }

    @Override
    public U createTile(int x, int y, int zoom, String url, AbstractTileFactory<T, U> tileFactory) {
        return null;
    }

    @Override
    public BlockingQueue<U> getTileQueue() {
        return null;
    }

    @Override
    protected Map<String, U> getTileMap() {
        return null;
    }
}

