/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.cache;

import java.lang.ref.SoftReference;
import nl.bebr.mapviewer.data.Tile;
import nl.bebr.mapviewer.data.cache.OfflineTileFactory;

public abstract class OfflineTile<T>
extends Tile<T> {
    protected static final int TILE_SIZE = 256;
    private boolean offline = false;

    public OfflineTile(int x, int y, int zoom, String url, OfflineTileFactory<T> tileFactory) {
        super(x, y, zoom, url, tileFactory);
        this.setLoading(false);
    }

    public void setImage(SoftReference<T> image) {
        this.image = image;
    }

    public void createOfflineImage() {
        this.setImage(new SoftReference<T>(this.createOfflineImageImpl()));
        this.offline = true;
    }

    public boolean isOffline() {
        return this.offline;
    }

    protected abstract T createOfflineImageImpl();
}

