/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.cache;

import nl.bebr.mapviewer.data.DefaultTileFactory;
import nl.bebr.mapviewer.data.Tile;
import nl.bebr.mapviewer.data.TileFactoryInfo;
import nl.bebr.mapviewer.data.cache.OfflineTile;
import nl.bebr.mapviewer.data.util.ConnectionChecker;
import nl.bebr.mapviewer.data.util.GeoUtil;

public abstract class OfflineTileFactory<T>
extends DefaultTileFactory<T, Tile<T>> {
    private ConnectionChecker connectionChecker = ConnectionChecker.getInstance();

    public OfflineTileFactory(TileFactoryInfo tileFactoryInfo) {
        super(tileFactoryInfo);
    }

    @Override
    public Tile<T> getTile(int x, int y, int zoom) {
        return this.getTileImpl(x, y, zoom, true);
    }

    private Tile<T> getTileImpl(int tpx, int tpy, int zoom, boolean eagerLoad) {
        Tile tile;
        int tileX = tpx;
        int numTilesWide = (int)this.getMapSize(zoom).getWidth();
        if (tileX < 0) {
            tileX = numTilesWide - Math.abs(tileX) % numTilesWide;
        }
        int tileY = tpy < 0 ? 0 : tpy;
        String url = this.getInfo().getTileUrl(tileX %= numTilesWide, tileY, zoom);
        if (!this.getTileMap().containsKey(url) || this.needRefresh(url)) {
            tile = this.createOfflineTile(tileX, tileY, zoom, url);
            if (GeoUtil.isValidTile(tileX, tileY, zoom, this.getInfo())) {
                this.startLoading(tile);
            }
            this.getTileMap().put(url, tile);
        } else {
            tile = (Tile)this.getTileMap().get(url);
            if (tile.getPriority() == Tile.Priority.Low && eagerLoad && !tile.isLoaded()) {
                this.promote(tile);
            }
        }
        return tile;
    }

    private boolean needRefresh(String url) {
        OfflineTile tile = (OfflineTile)this.getTileMap().get(url);
        return this.connectionChecker.isOnline() && tile.isOffline();
    }

    protected abstract Tile<T> createOfflineTile(int var1, int var2, int var3, String var4);
}

