/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.cache;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import nl.bebr.mapviewer.data.Tile;
import nl.bebr.mapviewer.data.TileCache;
import nl.bebr.mapviewer.data.cache.OfflineTile;
import nl.bebr.mapviewer.data.cache.OfflineTileFactory;
import nl.bebr.mapviewer.data.cache.TileCacheInfo;
import nl.bebr.mapviewer.data.cache.TileRepository;
import nl.bebr.mapviewer.data.cache.spi.CacheManager;
import nl.bebr.mapviewer.data.util.ConnectionChecker;

public abstract class OfflineTileRunner<T>
implements Runnable {
    private static final Logger LOG = Logger.getLogger(OfflineTileRunner.class.getName());
    private OfflineTileFactory<T> tileFactory;
    private TileCache<T> tileCache;
    private ConnectionChecker connectionChecker;
    private boolean running = true;
    private boolean persistent;

    public OfflineTileRunner(OfflineTileFactory<T> tileFactory) {
        this.tileFactory = tileFactory;
        this.connectionChecker = ConnectionChecker.getInstance();
        this.tileCache = tileFactory.getTileCache();
        this.persistent = tileFactory.getInfo().isPersistent();
    }

    protected URI getURI(Tile<T> tile) throws URISyntaxException {
        if (tile.getURL() == null) {
            return null;
        }
        return new URI(tile.getURL());
    }

    protected abstract T readTileFromRepository(TileCacheInfo var1);

    private void loadOneTile(final OfflineTile<T> tile) {
        int trys = 3;
        while (!tile.isLoaded() && trys > 0) {
            try {
                URI uri = this.getURI(tile);
                T img = this.tileCache.get(uri);
                if (img == null) {
                    TileCacheInfo info = this.tileFactory.getInfo().getCacheInfo(uri);
                    if (info != null && CacheManager.getInstance().isCached(info)) {
                        img = this.readTileFromRepository(info);
                        this.tileCache.put(uri, img);
                        img = this.tileCache.get(uri);
                    } else if (this.connectionChecker.isOnline()) {
                        img = this.loadImage(uri);
                        if (img != null) {
                            this.tileCache.put(uri, img);
                            img = this.tileCache.get(uri);
                            if (this.persistent) {
                                this.getTileRepository().writeTile(info, img);
                            }
                        }
                    } else {
                        this.offlineTile(tile);
                    }
                }
                if (img == null) {
                    --trys;
                    continue;
                }
                final T i = img;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        tile.setImage(new SoftReference<Object>(i));
                        tile.setLoaded(true);
                    }
                });
            }
            catch (OutOfMemoryError memErr) {
                this.tileCache.needMoreMemory();
            }
            catch (ConnectException | NoRouteToHostException | UnknownHostException ex) {
                this.offlineTile(tile);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Failed to load a tile at url: " + tile.getURL() + ", retrying", e);
                Throwable oldError = tile.getError();
                tile.setError(e);
                tile.firePropertyChangeOnEDT("loadingError", oldError, e);
                if (trys == 0) {
                    tile.firePropertyChangeOnEDT("unrecoverableError", null, e);
                    continue;
                }
                --trys;
            }
        }
        tile.setLoading(false);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                BlockingQueue queue = this.tileFactory.getTileQueue();
                if (queue != null) {
                    OfflineTile tile = (OfflineTile)queue.poll(1L, TimeUnit.DAYS);
                    if (tile == null || !this.running) continue;
                    this.loadOneTile(tile);
                    continue;
                }
                LOG.warning("Tile queue is null");
            }
            catch (Throwable ie) {
                LOG.log(Level.WARNING, "Error during picking tile from queue ", ie);
            }
        }
    }

    private void offlineTile(OfflineTile<T> tile) {
        tile.createOfflineImage();
        tile.setLoaded(true);
        tile.setLoading(false);
    }

    protected byte[] cacheInputStream(URL url) throws IOException {
        try {
            int n;
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("User-Agent", "MapViewer / 1.5.0");
            InputStream ins = conn.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((n = ins.read(buf)) != -1) {
                bout.write(buf, 0, n);
            }
            return bout.toByteArray();
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    public abstract T loadImage(URI var1) throws MalformedURLException, IOException;

    public abstract TileRepository<T> getTileRepository();

    public void stop() {
        this.running = false;
    }
}

