/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.cache;

public class TileCacheInfo {
    public static final String FILE_NAME_FORMAT = "%dx%d.%s";
    private static final String DEFAULT_EXTENSION = "png";
    private int zoom;
    private int x;
    private int y;
    private String path;
    private String extension = "png";
    private String type = null;

    public TileCacheInfo(int zoom, int x, int y) {
        this(zoom, x, y, null);
    }

    public TileCacheInfo(int zoom, int x, int y, String type) {
        this(zoom, x, y, type, DEFAULT_EXTENSION);
    }

    public TileCacheInfo(int zoom, int x, int y, String type, String extension) {
        this.zoom = zoom;
        this.x = x;
        this.y = y;
        this.type = type;
        this.extension = extension;
        this.path = this.getFileName(x, y);
    }

    private String getFileName(int x, int y) {
        return String.format(FILE_NAME_FORMAT, x, y, this.extension);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZoom() {
        return this.zoom;
    }

    public String getPath() {
        return this.path;
    }

    public void setExtension(String extension) {
        this.extension = extension;
        this.path = this.getFileName(this.x, this.y);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "TileCacheInfo [zoom=" + this.zoom + ", x=" + this.x + ", y=" + this.y + ", path=" + this.path + ", extension=" + this.extension + ", type=" + this.type + "]";
    }
}

