/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.bebr.mapviewer.data.cache.TileCacheInfo;
import nl.bebr.mapviewer.data.cache.TileService;
import nl.bebr.mapviewer.data.cache.WritableTileService;
import org.openide.util.Lookup;

public abstract class TileRepository<T> {
    private List<TileService> services = new ArrayList<TileService>();
    private WritableTileService<T> writableService;

    public TileRepository() {
        this.services.addAll(this.findImplementations());
        this.writableService = this.findWritableImplementation();
    }

    protected List<TileService> findImplementations() {
        Collection caches = Lookup.getDefault().lookupAll(TileService.class);
        return new ArrayList<TileService>(caches);
    }

    protected WritableTileService<T> findWritableImplementation() {
        return (WritableTileService)Lookup.getDefault().lookup(WritableTileService.class);
    }

    private TileService<T> getCacheThatContainsTile(TileCacheInfo tileCacheInfo) {
        TileService tileService = null;
        for (TileService service : this.services) {
            if (!service.contains(tileCacheInfo)) continue;
            tileService = service;
            break;
        }
        return tileService;
    }

    public T getTile(TileCacheInfo tileCacheInfo) {
        TileService<T> tileService = this.getCacheThatContainsTile(tileCacheInfo);
        return tileService != null ? (T)tileService.getTile(tileCacheInfo) : null;
    }

    public void writeTile(TileCacheInfo tileCacheInfo, T image) {
        if (this.writableService != null) {
            this.writableService.writeTile(tileCacheInfo, image);
        }
    }
}

