/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.cache.spi;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.bebr.mapviewer.data.cache.TileCacheInfo;
import nl.bebr.mapviewer.data.cache.TileService;
import nl.bebr.mapviewer.data.cache.WritableTileService;
import nl.bebr.mapviewer.data.cache.spi.CacheCleaner;
import nl.bebr.mapviewer.data.cache.spi.CacheManager;
import nl.bebr.mapviewer.data.util.FileUtil;
import org.openide.filesystems.FileObject;

public abstract class AbstractTileService<T>
implements WritableTileService<T>,
TileService<T> {
    private static final Logger LOG = Logger.getLogger(AbstractTileService.class.getName());
    private static final int HITS_TO_CLEAN_CACHE = 30;
    private int hitCounter = 0;

    protected FileObject getTileFile(TileCacheInfo tileCacheInfo, boolean createMissing) {
        FileObject zoomFolder = this.getZoomFolder(tileCacheInfo, createMissing);
        FileObject tileFile = null;
        if (zoomFolder != null && (tileFile = zoomFolder.getFileObject(tileCacheInfo.getPath())) == null && createMissing) {
            try {
                tileFile = zoomFolder.createData(tileCacheInfo.getPath());
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "Error creating tile file " + tileCacheInfo.getPath(), ex);
            }
        }
        return tileFile;
    }

    protected FileObject getZoomFolder(TileCacheInfo tileCacheInfo, boolean createMissing) {
        FileObject zoomFolder = null;
        String mapType = tileCacheInfo.getType();
        String zoomFolderName = String.format("%d", tileCacheInfo.getZoom());
        FileObject rootFolder = CacheManager.getInstance().getCacheFolder();
        if (rootFolder != null) {
            FileObject typeFolder = rootFolder.getFileObject(mapType);
            if (typeFolder == null) {
                try {
                    typeFolder = rootFolder.createFolder(mapType);
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, "Error creating folder " + typeFolder, ex);
                }
            }
            if (typeFolder != null && (zoomFolder = typeFolder.getFileObject(zoomFolderName)) == null && createMissing) {
                try {
                    zoomFolder = typeFolder.createFolder(zoomFolderName);
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, "Error creating folder " + zoomFolderName, ex);
                }
            }
        }
        return zoomFolder;
    }

    protected void readCallback(FileObject tileFile) {
        try {
            FileUtil.touch(tileFile);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "Error while touching file", ex);
        }
    }

    protected void writeCallback() {
        if (!CacheCleaner.getInstance().isUnlimited()) {
            ++this.hitCounter;
            if (this.hitCounter >= 30) {
                this.hitCounter = 0;
                CacheCleaner.getInstance().run();
            }
        }
    }

    @Override
    public boolean contains(TileCacheInfo tileCacheInfo) {
        return CacheManager.getInstance().isCached(tileCacheInfo);
    }

    @Override
    public T getTile(TileCacheInfo tileCacheInfo) {
        return this.readImage(tileCacheInfo);
    }

    @Override
    public void writeTile(TileCacheInfo tileCacheInfo, T image) {
        this.writeImage(tileCacheInfo, image);
    }

    public abstract T readImage(TileCacheInfo var1);

    public abstract void writeImage(TileCacheInfo var1, T var2);
}

