/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.cache.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.bebr.mapviewer.data.cache.spi.CacheManager;
import org.openide.filesystems.FileObject;

public class CacheCleaner {
    private static final Logger LOG = Logger.getLogger(CacheCleaner.class.getName());
    private static CacheCleaner instance = new CacheCleaner();
    public static final long DEFAULT_SIZE = 0x7D000000L;
    public static final long UNLIMITED_SIZE = -1L;
    private boolean running = false;
    private Comparator<FileObjectWrapper> comparator = (file1, file2) -> (int)(file2.getLastModifiedTime() - file1.getLastModifiedTime());
    protected long maximumCacheSize = 0x7D000000L;

    protected CacheCleaner() {
    }

    private List<FileObject> findCacheFiles(FileObject root) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        this.findCacheFiles(root, files);
        return files;
    }

    private void findCacheFiles(FileObject file, List<FileObject> files) {
        if (file != null) {
            if (file.isFolder()) {
                FileObject[] children;
                for (FileObject child : children = file.getChildren()) {
                    this.findCacheFiles(child, files);
                }
            } else {
                files.add(file);
            }
        }
    }

    private List<FileObject> getFilesToDelete(List<FileObjectWrapper> files) {
        long sizeSummary = 0L;
        ArrayList<FileObject> filesToDelete = new ArrayList<FileObject>();
        for (FileObjectWrapper file : files) {
            FileObject fileObject = file.getFileObject();
            if ((sizeSummary += fileObject.getSize()) <= this.maximumCacheSize) continue;
            filesToDelete.add(fileObject);
        }
        return filesToDelete;
    }

    private void deleteFiles(List<FileObjectWrapper> files) {
        List<FileObject> filesToDelete = this.getFilesToDelete(files);
        filesToDelete.stream().forEach(file -> this.safelyDelete((FileObject)file));
    }

    private void safelyDelete(FileObject file) {
        try {
            file.delete();
        }
        catch (Throwable t) {
            LOG.log(Level.FINER, "unable to delete cache file {0}, exception {1}", new Object[]{file.getPath(), t.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() {
        this.running = true;
        try {
            List<FileObject> files = this.findCacheFiles(this.getRootDir());
            ArrayList<FileObjectWrapper> fixDateFiles = new ArrayList<FileObjectWrapper>();
            for (FileObject fileObject : files) {
                FileObjectWrapper wrapper = new FileObjectWrapper(fileObject.lastModified().getTime(), fileObject);
                fixDateFiles.add(wrapper);
            }
            Collections.sort(fixDateFiles, this.comparator);
            this.deleteFiles(fixDateFiles);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.running = false;
        }
    }

    protected FileObject getRootDir() {
        return CacheManager.getInstance().getCacheFolder();
    }

    public void run() {
        if (this.running || this.isUnlimited()) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                CacheCleaner.this.runInternal();
            }
        });
        thread.setName("Cache deleting thread");
        thread.start();
    }

    public static CacheCleaner getInstance() {
        return instance;
    }

    public void setMaximumCacheSize(long maximumCacheSize) {
        long oldSize = this.maximumCacheSize;
        this.maximumCacheSize = maximumCacheSize;
        if (maximumCacheSize < oldSize && !this.isUnlimited() || oldSize == -1L && !this.isUnlimited()) {
            this.run();
        }
    }

    public boolean isUnlimited() {
        return this.maximumCacheSize == -1L;
    }

    private static class FileObjectWrapper {
        long lastModifiedTime;
        FileObject fileObject;

        public FileObjectWrapper(long lastModifiedTime, FileObject fileObject) {
            this.lastModifiedTime = lastModifiedTime;
            this.fileObject = fileObject;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }
    }
}

