/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.cache.spi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import nl.bebr.mapviewer.data.cache.TileCacheInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CacheManager {
    private static final String CACHE_ROOT_DIR = "tileCache";
    private static final Pattern DIR_PATTERN = Pattern.compile("\\d*");
    private static final Pattern CACHE_FILE_PATTERN = Pattern.compile("\\d*x\\d*");
    private static final CacheManager instance = new CacheManager();
    private static final Logger LOGGER = Logger.getLogger(CacheManager.class.getName());
    private final String userHome;
    private String mapTypeFolder = "OpenStreetMap";
    private int zoom = 7;
    private Map<Integer, Map<Integer, List<Integer>>> zoomMap = new HashMap<Integer, Map<Integer, List<Integer>>>();
    private long cacheSizeSum = 0L;

    protected CacheManager() {
        this.userHome = System.getProperty("user.home") + File.separatorChar + ".agrosense";
        this.refresh();
    }

    public static CacheManager getInstance() {
        return instance;
    }

    public void refresh() {
        this.zoomMap.clear();
        this.cacheSizeSum = 0L;
        FileObject cacheFolder = this.getCacheFolder();
        if (cacheFolder != null) {
            FileObject[] mapTypeFolders;
            for (FileObject child : mapTypeFolders = cacheFolder.getChildren()) {
                if (!child.isValid() || !child.isFolder() || !child.getName().equals(this.mapTypeFolder)) continue;
                this.processMapType(child);
            }
        }
    }

    private void processMapType(FileObject mapTypeFolder) {
        FileObject[] zoomFolders;
        for (FileObject child : zoomFolders = mapTypeFolder.getChildren()) {
            boolean zoomIsRight;
            boolean bl = zoomIsRight = DIR_PATTERN.matcher(child.getName()).matches() && (Integer.parseInt(child.getName()) == this.zoom || Integer.parseInt(child.getName()) == this.zoom + 1);
            if (!child.isValid() || !child.isFolder() || !zoomIsRight) continue;
            this.proccessFolder(child);
        }
    }

    public boolean isCached(TileCacheInfo tileCacheInfo) {
        int zoom = tileCacheInfo.getZoom();
        int x = tileCacheInfo.getX();
        int y = tileCacheInfo.getY();
        Map<Integer, List<Integer>> coordMap = this.zoomMap.get(zoom);
        if (coordMap != null) {
            List<Integer> yCoordList = coordMap.get(x);
            if (yCoordList != null) {
                return yCoordList.contains(y);
            }
            return false;
        }
        return false;
    }

    protected void proccessFolder(FileObject folder) {
        FileObject[] children;
        int zoom = Integer.parseInt(folder.getName());
        for (FileObject child : children = folder.getChildren()) {
            if (!child.isData() || !CACHE_FILE_PATTERN.matcher(child.getName()).matches()) continue;
            this.proccessFile(zoom, child);
        }
    }

    protected void proccessFile(int zoom, FileObject file) {
        String name = file.getName();
        String[] coords = name.split("x");
        if (coords != null && coords.length == 2) {
            int x = Integer.parseInt(coords[0]);
            int y = Integer.parseInt(coords[1]);
            this.addRecord(zoom, x, y);
        }
    }

    protected void addFileSize(FileObject file) {
        this.cacheSizeSum += file.getSize();
    }

    protected void addRecord(int zoom, int x, int y) {
        List<Integer> yCoords;
        Map<Integer, List<Integer>> map = this.zoomMap.get(zoom);
        if (map == null) {
            map = new HashMap<Integer, List<Integer>>();
            this.zoomMap.put(zoom, map);
        }
        if ((yCoords = map.get(x)) == null) {
            yCoords = new ArrayList<Integer>();
            map.put(x, yCoords);
        }
        yCoords.add(y);
    }

    public long getCacheSize() {
        return this.cacheSizeSum;
    }

    public FileObject getCacheFolder() {
        FileObject configFolder = FileUtil.getConfigRoot();
        FileObject configRoot = null;
        try {
            configRoot = FileUtil.createFolder((File)new File(this.userHome));
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Exception while getting root folder.", e);
        }
        if (configRoot != null && null == (configFolder = configRoot.getFileObject(CACHE_ROOT_DIR))) {
            try {
                configFolder = configRoot.createFolder(CACHE_ROOT_DIR);
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Exception while getting tile chache folder.", ex);
            }
        }
        return configFolder;
    }

    public void setZoomLevel(int zoom) {
        int oldZoom = this.zoom;
        this.zoom = zoom;
        if (zoom != oldZoom) {
            this.refresh();
        }
    }

    public void setMapTypeFolder(String mapTypeFolder) {
        String oldMapTypeFolder = this.mapTypeFolder;
        this.mapTypeFolder = mapTypeFolder;
        if (!oldMapTypeFolder.equals(mapTypeFolder)) {
            this.refresh();
        }
    }
}

