/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.esri;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import nl.bebr.mapviewer.data.AbstractTileFactory;
import nl.bebr.mapviewer.data.DefaultTileFactory;
import nl.bebr.mapviewer.data.GeoPosition;
import nl.bebr.mapviewer.data.Tile;
import nl.bebr.mapviewer.data.TileCache;
import nl.bebr.mapviewer.data.TileFactoryInfo;
import nl.bebr.mapviewer.data.util.GeoUtil;

public class ESRITileFactory<T, U extends Tile<T>>
extends DefaultTileFactory<T, U> {
    private static final String projection = "8";
    private static final String format = "png";
    private String userId;
    private String datasource;

    public ESRITileFactory() {
        super(new ESRITileProviderInfo());
        ((ESRITileProviderInfo)super.getInfo()).factory = this;
        this.datasource = "ArcWeb:TA.Streets.NA";
    }

    public void setUserID(String id) {
        this.userId = id;
    }

    @Override
    protected Runnable createTileRunner() {
        return null;
    }

    @Override
    public TileCache<T> createTileCache() {
        return null;
    }

    @Override
    public U createTile(int x, int y, int zoom, String url, AbstractTileFactory<T, U> tileFactory) {
        return null;
    }

    @Override
    public BlockingQueue<U> getTileQueue() {
        return null;
    }

    @Override
    protected Map<String, U> getTileMap() {
        return null;
    }

    private static final class ESRITileProviderInfo
    extends TileFactoryInfo {
        private ESRITileFactory<?, ?> factory;

        private ESRITileProviderInfo() {
            super(0, 17, 18, 256, false, true, "http://www.arcwebservices.com/services/v2006/restmap?actn=getMap", "", "", "");
        }

        @Override
        public String getTileUrl(int x, int y, int zoom) {
            int tileY = y;
            int tileX = x;
            int pixelX = tileX * this.factory.getTileSize(zoom) + this.factory.getTileSize(zoom) / 2;
            int pixelY = tileY * this.factory.getTileSize(zoom) + this.factory.getTileSize(zoom) / 2;
            GeoPosition latlong = GeoUtil.getPosition(new Point2D.Double(pixelX, pixelY), zoom, this);
            double numFeetPerDegreeLong = 364610.6933333333;
            double numPixelsPerDegreeLong = this.getLongitudeDegreeWidthInPixels(zoom);
            double numPixelsPerFoot = 1152.0;
            int sf = (int)(numFeetPerDegreeLong / (numPixelsPerDegreeLong / numPixelsPerFoot));
            BigDecimal lat = new BigDecimal(latlong.getLatitude());
            BigDecimal lon = new BigDecimal(latlong.getLongitude());
            lat = lat.setScale(5, RoundingMode.DOWN);
            lon = lon.setScale(5, RoundingMode.DOWN);
            String url = this.baseURL + "&usrid=" + ((ESRITileFactory)this.factory).userId + "&ds=" + ((ESRITileFactory)this.factory).datasource + "&c=" + lon.doubleValue() + "%7C" + lat.doubleValue() + "&sf=" + sf + "&fmt=" + ESRITileFactory.format + "&ocs=" + ESRITileFactory.projection;
            return url;
        }
    }
}

