/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.tilefactory;

import java.net.URI;
import nl.bebr.mapviewer.data.TileFactoryInfo;
import nl.bebr.mapviewer.data.cache.TileCacheInfo;

public class VirtualEarthTileFactoryInfo
extends TileFactoryInfo {
    public static final MVEMode MAP = new MVEMode("Map", "map", "r", ".png");
    public static final MVEMode SATELLITE = new MVEMode("Satellite", "satellite", "a", ".jpeg");
    public static final MVEMode HYBRID = new MVEMode("Hybrid", "hybrid", "h", ".jpeg");
    private static final int TOP_ZOOM_LEVEL = 19;
    private static final int MAX_ZOOM_LEVEL = 17;
    private static final int MIN_ZOOM_LEVEL = 1;
    private static final int TILE_SIZE = 256;
    private MVEMode mode;

    public VirtualEarthTileFactoryInfo(MVEMode mode) {
        super("VirtualEarth" + mode.name, 1, 17, 19, 256, false, false, "", "", "", "");
        this.mode = mode;
    }

    public String getModeName() {
        return this.mode.name;
    }

    public String getModeLabel() {
        return this.mode.label;
    }

    @Override
    public String getTileUrl(int x, int y, int zoom) {
        String quad = this.tileToQuadKey(x, y, this.recalculateZoom(zoom));
        return "http://" + this.mode.type + quad.charAt(quad.length() - 1) + ".ortho.tiles.virtualearth.net/tiles/" + this.mode.type + quad + this.mode.ext + "?g=1";
    }

    private String tileToQuadKey(int tx, int ty, int zl) {
        String quad = "";
        for (int i = zl; i > 0; --i) {
            int mask = 1 << i - 1;
            int cell = 0;
            if ((tx & mask) != 0) {
                ++cell;
            }
            if ((ty & mask) != 0) {
                cell += 2;
            }
            quad = quad + cell;
        }
        return quad;
    }

    @Override
    public synchronized TileCacheInfo getCacheInfo(URI uri) {
        String text = uri.getPath();
        String tileUri = text.substring(8, text.indexOf("."));
        int shift = 0;
        int x = 0;
        int y = 0;
        int zoom = tileUri.length();
        for (int i = tileUri.length() - 1; i >= 0; --i) {
            char ch = tileUri.charAt(i);
            int mask = 1 << shift;
            if ('1' == ch) {
                x |= mask;
            } else if ('2' == ch) {
                y |= mask;
            } else if ('3' == ch) {
                x |= mask;
                y |= mask;
            }
            ++shift;
        }
        zoom = this.recalculateZoom(zoom);
        TileCacheInfo tileCacheInfo = new TileCacheInfo(zoom, x, y);
        tileCacheInfo.setExtension(this.mode.ext.substring(1));
        tileCacheInfo.setType(this.getName());
        return tileCacheInfo;
    }

    @Override
    protected int recalculateZoom(int zoom) {
        return 19 - zoom;
    }

    public static class MVEMode {
        private String type;
        private String ext;
        private String name;
        private String label;

        private MVEMode(String name, String label, String type, String ext) {
            this.type = type;
            this.ext = ext;
            this.name = name;
            this.label = label;
        }
    }
}

