/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;

public class ConnectionChecker {
    private static final int INITIAL_DELAY = 0;
    private static final long CHECK_PERIOD_DEFAULT = 5000L;
    private static final String HOST_NAME_DEFAULT = "www.openstreetmap.org";
    private static final int PORT_NUMBER_DEFAULT = 80;
    private static final String PROPERTY_NAME = "status";
    private static final ConnectionChecker instance = new ConnectionChecker();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Timer timer;
    private boolean started = false;
    private boolean online = false;
    private long checkPeriod = 5000L;
    private String hostName = "www.openstreetmap.org";
    private int portNumber = 80;

    private ConnectionChecker() {
        this.start();
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                ConnectionChecker.this.doCheck();
            }
        };
    }

    private void doCheck() {
        boolean oldOnline = this.online;
        if (this.isOnlineFastCheck()) {
            try (Socket socket = new Socket(this.hostName, this.portNumber);){
                this.online = socket.getInputStream() != null;
            }
            catch (Throwable e) {
                this.online = false;
            }
        } else {
            this.online = false;
        }
        if (oldOnline != this.online) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_NAME, oldOnline, this.online);
        }
    }

    private boolean isOnlineFastCheck() {
        boolean check = false;
        try {
            InetAddress.getByName(this.hostName);
            check = true;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return check;
    }

    public static ConnectionChecker getInstance() {
        return instance;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        if (!this.started) {
            this.timer = new Timer("onlineChecker", true);
            this.timer.schedule(this.createTimerTask(), 0L, this.checkPeriod);
            this.started = true;
        }
    }

    public void stop() {
        if (this.started) {
            this.timer.cancel();
            this.timer = null;
            this.started = false;
        }
    }

    public boolean isOnline() {
        return this.online;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public long getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(long checkPeriod) {
        this.checkPeriod = checkPeriod;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void restart() {
        this.stop();
        this.start();
    }
}

