/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.util;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class GraphicsUtilities {
    public static BufferedImage loadCompatibleImage(InputStream in) throws IOException {
        BufferedImage image = ImageIO.read(in);
        if (image == null) {
            return null;
        }
        return GraphicsUtilities.toCompatibleImage(image);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (GraphicsUtilities.isHeadless()) {
            return image;
        }
        if (image.getColorModel().equals(GraphicsUtilities.getGraphicsConfiguration().getColorModel())) {
            return image;
        }
        BufferedImage compatibleImage = GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics g = compatibleImage.getGraphics();
        try {
            g.drawImage(image, 0, 0, null);
        }
        finally {
            g.dispose();
        }
        return compatibleImage;
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }
}

