/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.data.util;

import java.util.Locale;
import nl.bebr.mapviewer.data.util.Bundle;

public class ScaleUtil {
    private static final int HECTAR_TO_METER = 10000;
    private static final int KM_TRESHOLD = 2000;
    private static final double FEET = 0.3048;
    private static final double SQUARE_M_TO_FOOT = 10.7643;
    private static final double HA_TO_ACRES = 2.471;
    private static final double MILE_TO_M = 1609.3;
    private static final long[] SCALE_VALUES_METRIC = new long[]{50L, 100L, 250L, 500L, 1000L, 2000L, 4000L, 10000L, 15000L, 30000L, 50000L, 100000L, 250000L, 500000L, 1000000L, 2000000L, 4000000L};
    private static final long[] SCALE_VALUES_IMPERIAL = new long[]{200L, 500L, 1000L, 2000L, 4000L, 5280L, 10560L, 26400L, 52800L, 105600L, 158400L, 264000L, 792000L, 1584000L, 2640000L, 5280000L, 10560000L};

    public static long getScaleValue(int zoom) {
        UnitSystem unitSystem = ScaleUtil.getUnitSystem();
        switch (unitSystem) {
            case METRIC: {
                return ScaleUtil.getScaleValueMetric(zoom);
            }
            case IMPERIAL: {
                return ScaleUtil.getScaleValueImperial(zoom);
            }
        }
        return ScaleUtil.getScaleValueMetric(zoom);
    }

    public static UnitSystem getUnitSystem() {
        Locale defaultLocale = Locale.getDefault();
        String cc = defaultLocale.getCountry();
        if ("US".equals(cc) || "GB".equals(cc) || "CA".equals(cc)) {
            return UnitSystem.IMPERIAL;
        }
        return UnitSystem.METRIC;
    }

    public static String formatLength(double length) {
        UnitSystem unitSystem = ScaleUtil.getUnitSystem();
        String out = null;
        switch (unitSystem) {
            case IMPERIAL: {
                out = ScaleUtil.formatLengthImperial(length);
                break;
            }
            case METRIC: {
                out = ScaleUtil.formatLengthMetric(length);
                break;
            }
        }
        return out;
    }

    public static String formatLengthMetric(double length) {
        if (length > 2000.0) {
            return String.format("%.3f %s", length / 1000.0, Bundle.scale_kilometer());
        }
        return String.format("%.1f ", length, Bundle.scale_meter());
    }

    public static String formatLengthImperial(double length) {
        if (length > 1609.3) {
            return String.format("%.3f %s", length / 1609.3, Bundle.scale_mile());
        }
        return String.format("%.1f %s", length / 0.3048, Bundle.scale_feet());
    }

    public static String formatArea(double area) {
        UnitSystem unitSystem = ScaleUtil.getUnitSystem();
        String out = null;
        switch (unitSystem) {
            case IMPERIAL: {
                out = ScaleUtil.formatAreaImperial(area);
                break;
            }
            case METRIC: {
                out = ScaleUtil.formatAreaMetric(area);
                break;
            }
        }
        return out;
    }

    public static String formatAreaMetric(double area) {
        if (area > 1.0) {
            return String.format("%.3f %s", area, Bundle.scale_hectar());
        }
        return String.format("%.2f %s", area * 10000.0, Bundle.scale_square_meter());
    }

    public static String formatAreaImperial(double area) {
        if (area > 0.4046944556859571) {
            return String.format("%.3f %s", area * 2.471, Bundle.scale_acres());
        }
        return String.format("%.2f %s", area * 10000.0 * 10.7643, Bundle.scale_square_feet());
    }

    private static long getScaleValueMetric(int zoom) {
        if (zoom < 0) {
            throw new IllegalArgumentException("zoom must be positive");
        }
        if (zoom > SCALE_VALUES_METRIC.length) {
            throw new IllegalAccessError(String.format("maximum zoom value can be %d", SCALE_VALUES_METRIC.length));
        }
        return SCALE_VALUES_METRIC[zoom - 1];
    }

    private static long getScaleValueImperial(int zoom) {
        if (zoom < 0) {
            throw new IllegalArgumentException("zoom must be positive");
        }
        if (zoom > SCALE_VALUES_IMPERIAL.length) {
            throw new IllegalAccessError(String.format("maximum zoom value can be %d", SCALE_VALUES_IMPERIAL.length));
        }
        return SCALE_VALUES_IMPERIAL[zoom - 1];
    }

    public static double getUnitToMetersRatio() {
        UnitSystem systemUnit = ScaleUtil.getUnitSystem();
        switch (systemUnit) {
            case METRIC: {
                return 1.0;
            }
            case IMPERIAL: {
                return 0.3048;
            }
        }
        return 1.0;
    }

    public static enum UnitSystem {
        METRIC,
        IMPERIAL;

    }
}

