/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.mapviewer.demo.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import nl.bebr.mapviewer.data.GeoPosition;
import nl.bebr.mapviewer.data.TileFactory;
import nl.bebr.mapviewer.data.TileFactoryInfo;
import nl.bebr.mapviewer.data.tilefactory.OSMTileFactoryInfo;
import nl.bebr.mapviewer.data.tilefactory.VirtualEarthTileFactoryInfo;
import nl.bebr.mapviewer.data.util.ConnectionChecker;
import nl.bebr.mapviewer.swing.impl.OfflineTileFactorySwing;
import nl.bebr.mapviewer.swing.jxmap.map.JXMapPanel;
import nl.bebr.mapviewer.swing.jxmap.map.component.LayerSelectionComponent;
import nl.bebr.mapviewer.swing.overlay.CompoundOverlayPainter;
import org.jdesktop.swingx.painter.Painter;

public class DemoFrame
extends JFrame {
    private static final long serialVersionUID = 1L;

    public DemoFrame() {
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(3);
        this.setSize(1024, 768);
        ConnectionChecker.getInstance().start();
        OSMTileFactoryInfo osmInfo = new OSMTileFactoryInfo();
        osmInfo.setIconUrl(DemoFrame.class.getResource("osm.png"));
        VirtualEarthTileFactoryInfo vetfi1 = new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.MAP);
        VirtualEarthTileFactoryInfo vetfi2 = new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.SATELLITE);
        VirtualEarthTileFactoryInfo vetfi3 = new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.HYBRID);
        vetfi1.setIconUrl(DemoFrame.class.getResource("vem.png"));
        vetfi2.setIconUrl(DemoFrame.class.getResource("ves.png"));
        vetfi3.setIconUrl(DemoFrame.class.getResource("veh.png"));
        JXMapPanel mapViewer = new JXMapPanel();
        mapViewer.setTileFactory((TileFactory)new OfflineTileFactorySwing((TileFactoryInfo)osmInfo));
        GeoPosition greenwich = new GeoPosition(51.4788, 0.0106);
        mapViewer.setZoom(15);
        mapViewer.setAddressLocation(greenwich);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)mapViewer, "Center");
        mapViewer.setTypeSelectionEnabled(true, new TileFactoryInfo[]{osmInfo, vetfi1, vetfi2, vetfi3});
        this.setContentPane(p);
        mapViewer.setOverlayPainter((Painter)new CompoundOverlayPainter());
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        LayerSelectionComponent layerSelectionComponent = new LayerSelectionComponent();
        mapViewer.add((Component)panel);
        panel.add((Component)layerSelectionComponent);
    }

    public static void main(String[] args) {
        DemoFrame frame = new DemoFrame();
        frame.setVisible(true);
    }
}

