/**
 * Copyright (C) 2008-2013 LimeTri. All rights reserved.
 *
 * AgroSense is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * There are special exceptions to the terms and conditions of the GPLv3 as it
 * is applied to this software, see the FLOSS License Exception
 * <http://www.agrosense.eu/foss-exception.html>.
 *
 * AgroSense is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * AgroSense. If not, see <http://www.gnu.org/licenses/>.
 */
package nl.bebr.util.api.geo;

import java.util.concurrent.Callable;

import com.vividsolutions.jts.geom.Envelope;

/**
 *
 * @author Timon Veenstra <monezz@gmail.com>
 */
public abstract class DelayedInitializationGeographical<O extends Object> implements Geographical<O> {

    private final Callable<O> job;

    public DelayedInitializationGeographical(Callable<O> job) {
        this.job = job;
    }

    @Override
    public O getRenderObject(Envelope envelope) {
        try {
            return job.call();
        } catch (Exception ex) {
            return null;
        }
    }

}
