/**
 * Copyright (C) 2008-2013 LimeTri. All rights reserved.
 *
 * AgroSense is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * There are special exceptions to the terms and conditions of the GPLv3 as it is applied to
 * this software, see the FLOSS License Exception
 * <http://www.agrosense.eu/foss-exception.html>.
 *
 * AgroSense is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AgroSense.  If not, see <http://www.gnu.org/licenses/>.
 */
package nl.bebr.util.api.geo;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;


import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;


/**
 *
 * @author Timon Veenstra <monezz@gmail.com>
 */
public abstract class PolygonSupport implements Geometrical<Polygon> {

    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private com.vividsolutions.jts.geom.Polygon geometry;

    public PolygonSupport() {
    }

    public PolygonSupport(com.vividsolutions.jts.geom.Polygon geometry) {
        this.geometry = geometry;
    }

    @Override
    public com.vividsolutions.jts.geom.Polygon getGeometry() {
        return geometry;
    }

    @Override
    public Point getCentroid() {
        if (geometry != null) {
            return geometry.getCentroid();
        }
        return null;
    }

    @Override
    public Geometry getBoundingBox() {
        if (geometry != null) {
            return geometry.getEnvelope();
        }
        return null;
    }

    /**
     * Override this method if you need to optimize rendering for this object.
     * only return the part of the geometry that is within the provided envelope.
     * default implementation will always return the entire geometry
     * 
     * @param envelope
     * @return 
     */
    @Override
    public com.vividsolutions.jts.geom.Polygon getRenderObject(Envelope envelope) {
        return geometry;
    }

    @Override
    public String getTooltipText() {
        return "";
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public String getIconLabel() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }
}
