/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.util.api.geo;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class AutocorrectGeometries {
    public static Geometry autocorrect(Geometry g) {
        if (g == null) {
            return null;
        }
        if (g instanceof Polygon) {
            return AutocorrectGeometries.autocorrect(Collections.singletonList((Polygon)g));
        }
        if (g instanceof MultiPolygon) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            MultiPolygon mp = (MultiPolygon)g;
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                polygons.add((Polygon)mp.getGeometryN(i));
            }
            return AutocorrectGeometries.autocorrect(polygons);
        }
        return null;
    }

    public static MultiPolygon autocorrect(Collection<Polygon> polygonsIn) {
        if (polygonsIn == null || polygonsIn.isEmpty()) {
            return null;
        }
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (Polygon p : polygonsIn) {
            lines.add(p.getExteriorRing());
            for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                lines.add(p.getInteriorRingN(i));
            }
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        MultiLineString mls = new MultiLineString(lines.toArray(new LineString[lines.size()]), geometryFactory);
        Geometry union = mls.union((Geometry)mls);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(union);
        Collection polygonsOut = polygonizer.getPolygons();
        if (polygonsOut.isEmpty()) {
            return null;
        }
        MultiPolygon multiPolygon = new MultiPolygon(polygonsOut.toArray(new Polygon[polygonsOut.size()]), geometryFactory);
        IsValidOp validator = new IsValidOp((Geometry)multiPolygon);
        validator.setSelfTouchingRingFormingHoleValid(true);
        return validator.isValid() ? multiPolygon : null;
    }
}

