/*
 * Decompiled with CFR 0.152.
 */
package nl.bebr.util.api.geo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import nl.bebr.util.api.geo.DataRecord;
import nl.bebr.util.api.geo.DataSet;
import nl.bebr.util.api.geo.Geographical;

public class DataSetGeographical
implements Geographical<DataSet> {
    private final DataSet dataSet;
    private Point centroid;
    private Geometry boundingbox;
    private boolean boundingboxFixed = false;

    public DataSetGeographical(DataSet dataSet) {
        this(dataSet, null);
    }

    public DataSetGeographical(DataSet dataSet, Geometry boundingBox) {
        this.dataSet = dataSet;
        this.boundingbox = boundingBox;
        this.boundingboxFixed = boundingBox != null;
        this.recalculate();
        dataSet.addPropertyChangeListener(PropertyChangeEvent2 -> this.recalculate());
    }

    private void recalculate() {
        if (this.boundingboxFixed) {
            this.centroid = this.boundingbox.getCentroid();
        } else {
            double miny = this.dataSet.stream().map(DataRecord::getLat).reduce((Double)Double.MAX_VALUE, (a, b) -> a < b ? a : b);
            double minx = this.dataSet.stream().map(DataRecord::getLon).reduce((Double)Double.MAX_VALUE, (a, b) -> a < b ? a : b);
            double maxy = this.dataSet.stream().map(DataRecord::getLat).reduce((Double)Double.MIN_VALUE, (a, b) -> a > b ? a : b);
            double maxx = this.dataSet.stream().map(DataRecord::getLon).reduce((Double)Double.MIN_VALUE, (a, b) -> a > b ? a : b);
            Coordinate[] coordinates = new Coordinate[]{new Coordinate(minx, miny), new Coordinate(minx, maxy), new Coordinate(maxx, maxy), new Coordinate(maxx, miny), new Coordinate(minx, miny)};
            GeometryFactory geometryFactory = new GeometryFactory();
            this.boundingbox = geometryFactory.createPolygon(coordinates);
            this.centroid = this.boundingbox.getCentroid();
        }
    }

    @Override
    public Class<DataSet> getType() {
        return DataSet.class;
    }

    @Override
    public Point getCentroid() {
        return this.centroid;
    }

    @Override
    public Geometry getBoundingBox() {
        return this.boundingbox;
    }

    public void setBoundingbox(Geometry boundingbox) {
        this.boundingbox = boundingbox;
        this.boundingboxFixed = true;
        this.recalculate();
    }

    @Override
    public DataSet getRenderObject(Envelope envelope) {
        return this.dataSet;
    }

    @Override
    public String getTooltipText() {
        return "DataSet";
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public String getIconLabel() {
        return "DataSet";
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.dataSet.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.dataSet.removePropertyChangeListener(listener);
    }
}

