/**
 * Copyright (C) 2008-2013 LimeTri. All rights reserved.
 *
 * AgroSense is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * There are special exceptions to the terms and conditions of the GPLv3 as it
 * is applied to this software, see the FLOSS License Exception
 * <http://www.agrosense.eu/foss-exception.html>.
 *
 * AgroSense is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * AgroSense. If not, see <http://www.gnu.org/licenses/>.
 */

package nl.bebr.util.api.model;

import nl.bebr.util.api.model.aspect.HasId;
import nl.bebr.util.api.model.aspect.HasName;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;

/**
 *
 * @author johan
 */
public interface EntityType extends HasId<String>, HasName {

    interface Provider {
        EntityType[] getEntityTypes();
    }
    
    enum Registry {
        INSTANCE;
        
        private static final Logger LOG = Logger.getLogger(Registry.class.getName());
        private static final Map<String,EntityType> TYPES = new HashMap<>();
        
        // initialize types statically, can't reference static log via INSTANCE ctor:
        static {
            init();
        }
                
        public static Registry getInstance() {
            return INSTANCE;
        }
        
        public EntityType find(String id) {
            return TYPES.get(id);
        }
        
        public <T extends EntityType> T find(String id, Class<T> clazz) {
            EntityType t = TYPES.get(id);
            if (t != null && clazz.isAssignableFrom(t.getClass())) return (T) t;
            return null;
        }
        
        private static void init() {
            LOG.finest("init type registry");
            for (EntityType.Provider p : Lookup.getDefault().lookupAll(EntityType.Provider.class)) {
                LOG.log(Level.FINEST, "processing provider {0}", p.getClass().getName());
                for (EntityType type : p.getEntityTypes()) {
                    LOG.log(Level.FINEST, "register type {0} ({1})", new Object[]{type.getId(), type.getName()});
                    if (TYPES.put(type.getId(), type) != null) {
                        LOG.log(Level.SEVERE, "duplicate entry for type {0}", type.getId());
                        throw new IllegalStateException();
                    }
                }
            }
        }
        
    }
}
