/**
 * Copyright (C) 2008-2013 LimeTri. All rights reserved.
 *
 * AgroSense is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * There are special exceptions to the terms and conditions of the GPLv3 as it
 * is applied to this software, see the FLOSS License Exception
 * <http://www.agrosense.eu/foss-exception.html>.
 *
 * AgroSense is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * AgroSense. If not, see <http://www.gnu.org/licenses/>.
 */

package nl.bebr.util.api.model.id;

import nl.bebr.util.api.model.EntityType;
import nl.bebr.util.api.model.aspect.HasEntityType;
import java.util.Objects;

/**
 * ID that can provide the type of the entity it refers to.
 * 
 * @author johan
 * @param <T>
 */
public interface TypedId<T extends EntityType> extends CompositeId, HasEntityType<T> {
    //String getEntityTypeKey();
    
    // wrapper for simple IDs, combine properties from record/vertex/presentationModel/...
    class TupleImpl implements TypedId {
        
        private final EntityType type;
        //private final String typeKey;
        private final String originalId;

        public TupleImpl(EntityType type, String originalId) {
            this.type = type;
            this.originalId = originalId;
        }
        
        public TupleImpl(String typeKey, String originalId) {
            this.type = EntityType.Registry.getInstance().find(typeKey);
            this.originalId = originalId;
        }
        
        @Override
        public EntityType getEntityType() {
            return type;
        }

        @Override
        public String[] getParts() {
            return new String[] {type.getId(), originalId};
        }

        public String getOriginalId() {
            return originalId;
        }

        @Override
        public String toString() {
            return originalId;
        }

        @Override
        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + Objects.hashCode(this.type);
            hash = 89 * hash + Objects.hashCode(this.originalId);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            final TupleImpl other = (TupleImpl) obj;
            if (!Objects.equals(this.type, other.type)) {
                return false;
            }
            if (!Objects.equals(this.originalId, other.originalId)) {
                return false;
            }
            return true;
        }
        
    }
}
