/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import nl.bstoi.poiparser.api.strategy.converter.Converter;
import nl.bstoi.poiparser.core.exception.NonExistentConverterException;
import nl.bstoi.poiparser.core.exception.PoiParserRuntimeException;
import nl.bstoi.poiparser.core.strategy.CellDescriptor;
import nl.bstoi.poiparser.core.strategy.ColumnHeaderProperties;
import nl.bstoi.poiparser.core.strategy.factory.DefaultConverterFactory;
import nl.bstoi.poiparser.core.strategy.util.TypedList;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractWritePoiParser {
    private static final Log log = LogFactory.getLog(AbstractWritePoiParser.class);
    private final DefaultConverterFactory DEFAULTCONVERTERFACTORY = new DefaultConverterFactory();
    private boolean createHeaderRow = false;
    private final Workbook workbook;
    private ColumnHeaderProperties columnHeaderProperties;

    protected AbstractWritePoiParser(Workbook workbook) {
        this.workbook = workbook;
    }

    protected void writeSheet(String sheetName, TypedList<?> values, Set<CellDescriptor> sheetCellDescriptors) {
        Sheet sheet = this.workbook.createSheet(sheetName);
        if (this.isCreateHeaderRow()) {
            this.writeHeaderRow(sheet, sheetCellDescriptors);
        }
        this.writeDataRows(sheet, values, sheetCellDescriptors);
    }

    protected void writeHeaderRow(Sheet sheet, Set<CellDescriptor> sheetCellDescriptors) {
        if (sheet != null) {
            Row headerRow = sheet.createRow(0);
            for (CellDescriptor sheetCellDescriptor : sheetCellDescriptors) {
                this.writeHeaderCell(sheet.getSheetName(), headerRow, sheetCellDescriptor);
            }
        }
    }

    protected void writeHeaderCell(String sheetName, Row headerRow, CellDescriptor sheetCellDescriptor) {
        try {
            if (!sheetCellDescriptor.isWriteIgnore()) {
                Cell cell = headerRow.createCell(sheetCellDescriptor.getColumnNumber());
                String headerColumnName = sheetCellDescriptor.getFieldName();
                if (this.hasColumnHeaderProperties() && this.getColumnHeaderProperties().containsColumnHeader(sheetName, headerColumnName)) {
                    headerColumnName = this.getColumnHeaderProperties().getColumnHeader(sheetName, headerColumnName);
                }
                Converter<?> converter = this.DEFAULTCONVERTERFACTORY.getConverter(String.class);
                converter.writeCell(cell, headerColumnName);
            }
        }
        catch (InstantiationException e) {
            log.trace((Object)String.format("Error writing column header on row %s and column %s with propertyname %s", 0, sheetCellDescriptor.getColumnNumber(), sheetCellDescriptor.getFieldName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.trace((Object)String.format("Error writing column header on row %s and column %s with propertyname %s", 0, sheetCellDescriptor.getColumnNumber(), sheetCellDescriptor.getFieldName()), (Throwable)e);
        }
        catch (NonExistentConverterException e) {
            log.trace((Object)"Converter cannot be found", (Throwable)e);
        }
    }

    protected void writeDataRows(Sheet sheet, TypedList<?> values, Set<CellDescriptor> sheetCellDescriptors) {
        if (null != sheet) {
            int index = this.isCreateHeaderRow() ? 1 : 0;
            for (Object value : values) {
                this.writeDataRow(sheet, index, value, sheetCellDescriptors);
                ++index;
            }
        }
    }

    protected void writeDataRow(Sheet sheet, int index, Object value, Set<CellDescriptor> sheetCellDescriptors) {
        Row row = sheet.createRow(index);
        for (CellDescriptor cellDescriptor : sheetCellDescriptors) {
            Object cellValue = this.readCellValueFromObjectProperty(value, cellDescriptor.getFieldName());
            this.writeDataCell(row, cellValue, cellDescriptor);
        }
    }

    protected void writeDataCell(Row row, Object cellValue, CellDescriptor cellDescriptor) {
        Cell cell = row.createCell(cellDescriptor.getColumnNumber());
        if (!cellDescriptor.isWriteIgnore()) {
            try {
                Converter<?> converter = this.DEFAULTCONVERTERFACTORY.getConverter(cellDescriptor.getType());
                converter.writeCell(cell, cellValue);
            }
            catch (InstantiationException e) {
                log.trace((Object)String.format("Error writing cell on row %s and column %s with propertyname %s", row.getRowNum(), cellDescriptor.getColumnNumber(), cellDescriptor.getFieldName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.trace((Object)String.format("Error writing cell on row %s and column %s with propertyname %s", row.getRowNum(), cellDescriptor.getColumnNumber(), cellDescriptor.getFieldName()), (Throwable)e);
            }
            catch (NonExistentConverterException e) {
                log.trace((Object)"Converter cannot be found", (Throwable)e);
            }
        }
    }

    protected Object readCellValueFromObjectProperty(Object object, String propertyName) {
        if (null == object) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        if (StringUtils.isEmpty((String)propertyName)) {
            throw new IllegalArgumentException("Property name cannot be null");
        }
        try {
            return PropertyUtils.getNestedProperty((Object)object, (String)propertyName);
        }
        catch (IllegalAccessException e) {
            throw new PoiParserRuntimeException(String.format("Property %s cannot be read", propertyName), e);
        }
        catch (InvocationTargetException e) {
            throw new PoiParserRuntimeException(String.format("Property %s cannot be read", propertyName), e);
        }
        catch (NoSuchMethodException e) {
            return this.readCellValueFromObjectField(object, propertyName);
        }
    }

    protected Object readCellValueFromObjectField(Object object, String fieldName) {
        String[] splittedFieldNames = this.getSplittedPropertyName(fieldName);
        Object returnObject = null;
        for (String splittedFieldName : splittedFieldNames) {
            returnObject = this.getFieldFromObject(object, splittedFieldName);
            if (returnObject != null) continue;
            return null;
        }
        return returnObject;
    }

    private Object getFieldFromObject(Object object, String fieldName) {
        try {
            Field field = object.getClass().getField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public boolean isCreateHeaderRow() {
        return this.createHeaderRow;
    }

    public void setCreateHeaderRow(boolean createHeaderRow) {
        this.createHeaderRow = createHeaderRow;
    }

    protected Workbook getWorkbook() {
        return this.workbook;
    }

    protected String[] getSplittedPropertyName(String propertyName) {
        if (StringUtils.isEmpty((String)propertyName)) {
            throw new IllegalArgumentException("Property name cannot be empty");
        }
        return propertyName.split("\\.");
    }

    private ColumnHeaderProperties getColumnHeaderProperties() {
        return this.columnHeaderProperties;
    }

    private boolean hasColumnHeaderProperties() {
        return null != this.columnHeaderProperties;
    }

    public void setColumnHeaderProperties(ColumnHeaderProperties columnHeaderProperties) {
        this.columnHeaderProperties = columnHeaderProperties;
    }
}

