/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.converter;

import nl.bstoi.poiparser.api.strategy.converter.Converter;
import nl.bstoi.poiparser.core.strategy.converter.CellType;
import org.apache.commons.lang.ArrayUtils;
import org.apache.poi.ss.usermodel.Cell;

public abstract class AbstractConverter<T>
implements Converter<T> {
    private final CellType[] supportedCellTypes;

    protected AbstractConverter(CellType[] supportedCellTypes) {
        this.supportedCellTypes = supportedCellTypes;
    }

    protected boolean isCellTypeSupported(Cell cell) {
        if (null != cell) {
            CellType cellType = this.getCellType(cell);
            return ArrayUtils.contains((Object[])this.supportedCellTypes, (Object)((Object)cellType));
        }
        throw new NullPointerException("Cell cannot be null");
    }

    protected CellType getCellType(Cell cell) {
        return CellType.getCellTypeBasedOnNumeric(cell.getCellType());
    }
}

