/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.converter;

public enum CellType {
    NUMERIC(0),
    STRING(1),
    FORMULA(2),
    BLANK(3),
    BOOLEAN(4);

    private final int numericCellType;

    private CellType(int numericCellType) {
        this.numericCellType = numericCellType;
    }

    public int getNumericCellType() {
        return this.numericCellType;
    }

    public static CellType getCellTypeBasedOnNumeric(int numericCellType) {
        for (CellType cellType : CellType.values()) {
            if (cellType.getNumericCellType() != numericCellType) continue;
            return cellType;
        }
        throw new IllegalStateException(String.format("CellType with numeric value %d cannot be found", numericCellType));
    }
}

