/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class PoiImportExportUtil {
    private static final Log log = LogFactory.getLog(PoiImportExportUtil.class);

    public static List<String> getSheetNames(File excelFile) {
        try {
            log.debug((Object)("Loading sheet names from excel file:" + excelFile.getName()));
            return PoiImportExportUtil.getSheetNames(new FileInputStream(excelFile));
        }
        catch (FileNotFoundException e) {
            log.error((Object)("File: " + excelFile.getName() + " cannot be found."));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSheetNames(InputStream inputStream) {
        POIFSFileSystem poifs = null;
        try {
            poifs = new POIFSFileSystem(inputStream);
            HSSFWorkbook workbook = new HSSFWorkbook(poifs);
            ArrayList<String> sheetList = new ArrayList<String>();
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                log.trace((Object)("Adding sheet name: " + workbook.getSheetName(i)));
                sheetList.add(workbook.getSheetName(i));
            }
            inputStream.close();
            ArrayList<String> arrayList = sheetList;
            return arrayList;
        }
        catch (IOException e) {
            log.error((Object)"Error while reading excel file");
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return null;
    }

    public static List<String> readExcelFiles(String path) {
        log.debug((Object)("Listing excel files from path: " + path));
        File directoryPath = new File(path);
        ArrayList<String> fileList = new ArrayList<String>();
        if (directoryPath.exists() && directoryPath.isDirectory()) {
            for (File file : directoryPath.listFiles()) {
                fileList.add(file.getName());
            }
        }
        return fileList;
    }
}

