/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.annotation;

import java.io.InputStream;
import java.util.Set;
import nl.bstoi.poiparser.core.exception.PoiParserException;
import nl.bstoi.poiparser.core.strategy.AbstractPoiParserFactory;
import nl.bstoi.poiparser.core.strategy.CellDescriptor;
import nl.bstoi.poiparser.core.strategy.ReadPoiParser;
import nl.bstoi.poiparser.core.strategy.ReadPoiParserFactory;
import nl.bstoi.poiparser.core.strategy.annotation.AnnotatedClassDescriber;
import nl.bstoi.poiparser.core.strategy.annotation.AnnotatedReadPoiParser;
import org.apache.commons.lang.StringUtils;

public class AnnotatedReadPoiParserFactory<T>
extends AbstractPoiParserFactory
implements ReadPoiParserFactory<T> {
    private Set<CellDescriptor> overrideCellDescriptors;
    private final Class<T> clazz;

    public AnnotatedReadPoiParserFactory(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public ReadPoiParser<T> createReadPoiParser(InputStream excelInputStream, String sheetName) throws PoiParserException {
        if (null == excelInputStream) {
            throw new IllegalArgumentException("Excel input stream cannot be null");
        }
        if (StringUtils.isEmpty((String)sheetName)) {
            throw new IllegalArgumentException("Sheet name cannot be empty");
        }
        AnnotatedReadPoiParser<T> annotatedReadPoiParser = new AnnotatedReadPoiParser<T>(this.getCellDescriptors(), this.getSheetFromInputStream(excelInputStream, sheetName), this.clazz);
        annotatedReadPoiParser.setIgnoreFirstRow(this.ignoreFirstRow);
        return annotatedReadPoiParser;
    }

    @Override
    public Set<CellDescriptor> getCellDescriptors() {
        if (null == this.overrideCellDescriptors) {
            AnnotatedClassDescriber annotatedClassDescriber = AnnotatedClassDescriber.getInstance();
            return annotatedClassDescriber.getCellDescriptorsForClass(this.clazz);
        }
        return this.overrideCellDescriptors;
    }

    public void setOverrideCellDescriptors(Set<CellDescriptor> overrideCellDescriptors) {
        this.overrideCellDescriptors = overrideCellDescriptors;
    }
}

