/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.annotation;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import nl.bstoi.poiparser.core.exception.PoiParserException;
import nl.bstoi.poiparser.core.strategy.AbstractWritePoiParser;
import nl.bstoi.poiparser.core.strategy.CellDescriptor;
import nl.bstoi.poiparser.core.strategy.WritePoiParser;
import nl.bstoi.poiparser.core.strategy.annotation.AnnotatedClassDescriber;
import nl.bstoi.poiparser.core.strategy.util.TypedList;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.Workbook;

public class AnnotatedWritePoiParser
extends AbstractWritePoiParser
implements WritePoiParser {
    private final OutputStream outputStream;

    public AnnotatedWritePoiParser(OutputStream outputStream, Workbook workbook) {
        super(workbook);
        this.outputStream = outputStream;
    }

    @Override
    public void write(Map<String, TypedList<?>> sheetDataset) throws PoiParserException {
        if (null == sheetDataset) {
            throw new IllegalArgumentException("Sheet dataset name cannot be null");
        }
        try {
            for (String sheetName : sheetDataset.keySet()) {
                TypedList<?> sheetData = sheetDataset.get(sheetName);
                this.writeSheet(sheetName, sheetData, this.getCellDescriptorsForGenericList(sheetData));
            }
            this.getWorkbook().write(this.outputStream);
        }
        catch (IOException e) {
            throw new PoiParserException("Error while writing output stream", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.outputStream);
        }
    }

    private Set<CellDescriptor> getCellDescriptorsForGenericList(TypedList<?> list) {
        AnnotatedClassDescriber annotatedClassDescriber = AnnotatedClassDescriber.getInstance();
        Set<CellDescriptor> cellDescriptors = annotatedClassDescriber.getCellDescriptorsForClass(list.getType());
        return cellDescriptors;
    }
}

