/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.converter;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import nl.bstoi.poiparser.core.strategy.converter.AbstractConverter;
import nl.bstoi.poiparser.core.strategy.converter.CellType;
import org.apache.poi.ss.usermodel.Cell;

public class BigDecimalConverter
extends AbstractConverter<BigDecimal> {
    private static final CellType[] supportedCellTypes = new CellType[]{CellType.NUMERIC, CellType.STRING};

    public BigDecimalConverter() {
        super(supportedCellTypes);
    }

    @Override
    public BigDecimal readCell(Cell cell) {
        return this.readCell(cell, null);
    }

    @Override
    public BigDecimal readCell(Cell cell, String regex) {
        BigDecimal returnValue = null;
        Double cellValue = null;
        if (this.isCorrectCellType(cell)) {
            CellType cellType = this.getCellType(cell);
            switch (cellType) {
                case NUMERIC: {
                    cellValue = this.getCellValueFromNumeric(cell, regex);
                    break;
                }
                case STRING: {
                    cellValue = this.getCellValueFromString(cell, regex);
                }
            }
        }
        if (null != cellValue) {
            returnValue = new BigDecimal(cellValue);
        }
        return returnValue;
    }

    private Double getCellValueFromNumeric(Cell cell, String regex) {
        Double cellValue;
        try {
            cellValue = cell.getNumericCellValue();
        }
        catch (IllegalStateException e) {
            cellValue = this.getCellValueFromString(cell, regex);
        }
        return cellValue;
    }

    private Double getCellValueFromString(Cell cell, String regex) {
        Double cellValue = this.hasRegex(regex) ? this.readCellWithRegex(cell, regex) : Double.valueOf(Double.parseDouble(cell.getRichStringCellValue().getString().trim()));
        return cellValue;
    }

    private boolean hasRegex(String regex) {
        return null != regex && !regex.isEmpty();
    }

    private boolean isCorrectCellType(Cell cell) {
        return null != cell && this.isCellTypeSupported(cell);
    }

    private Double readCellWithRegex(Cell cell, String regex) {
        Double cellValue = null;
        Pattern pattern = Pattern.compile(regex);
        if (pattern.matcher(cell.getRichStringCellValue().getString().trim()).matches()) {
            cellValue = Double.parseDouble(cell.getRichStringCellValue().getString().trim());
        }
        return cellValue;
    }

    @Override
    public void writeCell(Cell cell, BigDecimal value) {
        if (null != value) {
            cell.setCellValue(value.doubleValue());
        }
    }
}

