/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.converter;

import nl.bstoi.poiparser.core.strategy.converter.AbstractConverter;
import nl.bstoi.poiparser.core.strategy.converter.CellType;
import org.apache.poi.ss.usermodel.Cell;

public class BooleanConverter
extends AbstractConverter<Boolean> {
    public static final String[] trueStringValue = new String[]{"yes", "true", "1"};
    public static final int[] trueIntegerValue = new int[]{1};
    private static final CellType[] supportedCellTypes = new CellType[]{CellType.NUMERIC, CellType.BOOLEAN, CellType.STRING};

    public BooleanConverter() {
        super(supportedCellTypes);
    }

    @Override
    public Boolean readCell(Cell cell) {
        boolean returnValue = false;
        if (this.isValidCell(cell)) {
            CellType cellType = this.getCellType(cell);
            if (CellType.BOOLEAN == cellType) {
                returnValue = cell.getBooleanCellValue();
            } else if (CellType.NUMERIC == cellType) {
                returnValue = this.getReturnValueAsNumeric(cell, returnValue);
            } else if (CellType.STRING == cellType) {
                returnValue = this.getReturnValueAsString(cell, returnValue);
            }
        }
        return returnValue;
    }

    private boolean getReturnValueAsString(Cell cell, boolean returnValue) {
        for (String trueValue : trueStringValue) {
            if (!trueValue.equalsIgnoreCase(cell.getRichStringCellValue().getString().trim())) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    private boolean getReturnValueAsNumeric(Cell cell, boolean returnValue) {
        Double cellValue = cell.getNumericCellValue();
        for (int trueValue : trueIntegerValue) {
            if (trueValue != cellValue.intValue()) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    private boolean isValidCell(Cell cell) {
        return null != cell && this.isCellTypeSupported(cell);
    }

    @Override
    public Boolean readCell(Cell cell, String regex) {
        return this.readCell(cell);
    }

    @Override
    public void writeCell(Cell cell, Boolean value) {
        if (null != value) {
            cell.setCellValue(value.booleanValue());
        }
    }
}

