/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.converter;

import java.util.Calendar;
import nl.bstoi.poiparser.core.strategy.converter.AbstractConverter;
import nl.bstoi.poiparser.core.strategy.converter.CellType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;

public class CalendarConverter
extends AbstractConverter<Calendar> {
    private static final CellType[] supportedCellTypes = new CellType[]{CellType.NUMERIC};

    public CalendarConverter() {
        super(supportedCellTypes);
    }

    @Override
    public Calendar readCell(Cell cell) {
        Calendar returnValue = null;
        if (this.hasValidCell(cell)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(cell.getDateCellValue());
            returnValue = cal;
        }
        return returnValue;
    }

    private boolean hasValidCell(Cell cell) {
        return null != cell && this.isCellTypeSupported(cell) && DateUtil.isCellDateFormatted((Cell)cell);
    }

    @Override
    public Calendar readCell(Cell cell, String regex) {
        return this.readCell(cell);
    }

    @Override
    public void writeCell(Cell cell, Calendar value) {
        if (null != value) {
            cell.setCellValue(value);
        }
    }
}

